/************************************************************************************************/
/* Stata User File for H171 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H171.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H171.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H171.DO                                               */
/* The program below will output the Stata dataset H171.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID14 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  byte   FCSZ1231 31-32
  byte   FCRP1231 33-34
  str    RULETR31 35-36
  str    RULETR42 37-38
  str    RULETR53 39-40
  str    RULETR14 41-42
  byte   RUSIZE31 43-44
  byte   RUSIZE42 45-46
  byte   RUSIZE53 47-48
  byte   RUSIZE14 49-50
  byte   RUCLAS31 51-52
  byte   RUCLAS42 53-54
  byte   RUCLAS53 55-56
  byte   RUCLAS14 57-57
  byte   FAMSZE31 58-59
  byte   FAMSZE42 60-61
  byte   FAMSZE53 62-63
  byte   FAMSZE14 64-65
  byte   FMRS1231 66-67
  byte   FAMS1231 68-69
  byte   FAMSZEYR 70-71
  byte   FAMRFPYR 72-72
  byte   REGION31 73-74
  byte   REGION42 75-76
  byte   REGION53 77-78
  byte   REGION14 79-80
  int    REFPRS31 81-83
  int    REFPRS42 84-86
  int    REFPRS53 87-89
  int    REFPRS14 90-92
  byte   RESP31 93-93
  byte   RESP42 94-94
  byte   RESP53 95-95
  byte   RESP14 96-96
  byte   PROXY31 97-98
  byte   PROXY42 99-100
  byte   PROXY53 101-102
  byte   PROXY14 103-103
  byte   INTVLANG 104-105
  byte   BEGRFM31 106-107
  int    BEGRFY31 108-111
  byte   ENDRFM31 112-113
  int    ENDRFY31 114-117
  byte   BEGRFM42 118-119
  int    BEGRFY42 120-123
  byte   ENDRFM42 124-125
  int    ENDRFY42 126-129
  byte   BEGRFM53 130-131
  int    BEGRFY53 132-135
  byte   ENDRFM53 136-137
  int    ENDRFY53 138-141
  byte   ENDRFM14 142-143
  int    ENDRFY14 144-147
  byte   KEYNESS 148-148
  byte   INSCOP31 149-149
  byte   INSCOP42 150-150
  byte   INSCOP53 151-151
  byte   INSCOP14 152-152
  byte   INSC1231 153-153
  byte   INSCOPE 154-154
  byte   ELGRND31 155-155
  byte   ELGRND42 156-156
  byte   ELGRND53 157-157
  byte   ELGRND14 158-158
  byte   PSTATS31 159-160
  byte   PSTATS42 161-162
  byte   PSTATS53 163-164
  str    RURSLT31 165-166
  str    RURSLT42 167-168
  str    RURSLT53 169-170
  byte   AGE31X 171-172
  byte   AGE42X 173-174
  byte   AGE53X 175-176
  byte   AGE14X 177-178
  byte   AGELAST 179-180
  byte   DOBMM 181-182
  int    DOBYY 183-186
  byte   SEX 187-187
  byte   RACEV1X 188-188
  byte   RACEV2X 189-190
  byte   RACEAX 191-191
  byte   RACEBX 192-192
  byte   RACEWX 193-193
  byte   RACETHX 194-194
  byte   HISPANX 195-195
  byte   HISPNCAT 196-196
  byte   MARRY31X 197-198
  byte   MARRY42X 199-200
  byte   MARRY53X 201-202
  byte   MARRY14X 203-204
  int    SPOUID31 205-207
  int    SPOUID42 208-210
  int    SPOUID53 211-213
  int    SPOUID14 214-216
  byte   SPOUIN31 217-218
  byte   SPOUIN42 219-220
  byte   SPOUIN53 221-222
  byte   SPOUIN14 223-224
  byte   EDUYRDG 225-226
  byte   EDUCYR 227-228
  byte   EDRECODE 229-230
  byte   FTSTU31X 231-232
  byte   FTSTU42X 233-234
  byte   FTSTU53X 235-236
  byte   FTSTU14X 237-238
  byte   ACTDTY31 239-240
  byte   ACTDTY42 241-242
  byte   ACTDTY53 243-244
  byte   HONRDC31 245-246
  byte   HONRDC42 247-248
  byte   HONRDC53 249-250
  byte   REFRL31X 251-252
  byte   REFRL42X 253-254
  byte   REFRL53X 255-256
  byte   REFRL14X 257-258
  byte   OTHLANG 259-260
  byte   LANGSPK 261-262
  byte   HWELLSPE 263-264
  byte   BORNUSA 265-266
  byte   YRSINUS 267-268
  int    MOPID31X 269-271
  int    MOPID42X 272-274
  int    MOPID53X 275-277
  int    DAPID31X 278-280
  int    DAPID42X 281-283
  int    DAPID53X 284-286
  byte   RTHLTH31 287-288
  byte   RTHLTH42 289-290
  byte   RTHLTH53 291-292
  byte   MNHLTH31 293-294
  byte   MNHLTH42 295-296
  byte   MNHLTH53 297-298
  byte   HIBPDX 299-300
  byte   HIBPAGED 301-302
  byte   BPMLDX 303-304
  byte   CHDDX 305-306
  byte   CHDAGED 307-308
  byte   ANGIDX 309-310
  byte   ANGIAGED 311-312
  byte   MIDX 313-314
  byte   MIAGED 315-316
  byte   OHRTDX 317-318
  byte   OHRTAGED 319-320
  byte   STRKDX 321-322
  byte   STRKAGED 323-324
  byte   EMPHDX 325-326
  byte   EMPHAGED 327-328
  byte   CHBRON31 329-330
  byte   CHBRON53 331-332
  byte   CHOLDX 333-334
  byte   CHOLAGED 335-336
  byte   CANCERDX 337-338
  byte   CABLADDR 339-340
  byte   CABREAST 341-342
  byte   CACERVIX 343-344
  byte   CACOLON 345-346
  byte   CALUNG 347-348
  byte   CALYMPH 349-350
  byte   CAMELANO 351-352
  byte   CAOTHER 353-354
  byte   CAPROSTA 355-356
  byte   CASKINNM 357-358
  byte   CASKINDK 359-360
  byte   CAUTERUS 361-362
  byte   DIABDX 363-364
  byte   DIABAGED 365-366
  byte   JTPAIN31 367-368
  byte   JTPAIN53 369-370
  byte   ARTHDX 371-372
  byte   ARTHTYPE 373-374
  byte   ARTHAGED 375-376
  byte   ASTHDX 377-378
  byte   ASTHAGED 379-380
  byte   ASSTIL31 381-382
  byte   ASSTIL53 383-384
  byte   ASATAK31 385-386
  byte   ASATAK53 387-388
  byte   ASTHEP31 389-390
  byte   ASTHEP53 391-392
  byte   ASACUT53 393-394
  byte   ASMRCN53 395-396
  byte   ASPREV53 397-398
  byte   ASDALY53 399-400
  byte   ASPKFL53 401-402
  byte   ASEVFL53 403-404
  byte   ASWNFL53 405-406
  byte   ADHDADDX 407-408
  byte   ADHDAGED 409-410
  byte   PREGNT31 411-412
  byte   PREGNT42 413-414
  byte   PREGNT53 415-416
  byte   IADLHP31 417-418
  byte   IADLHP53 419-420
  byte   ADLHLP31 421-422
  byte   ADLHLP53 423-424
  byte   AIDHLP31 425-426
  byte   AIDHLP53 427-428
  byte   WLKLIM31 429-430
  byte   WLKLIM53 431-432
  byte   LFTDIF31 433-434
  byte   LFTDIF53 435-436
  byte   STPDIF31 437-438
  byte   STPDIF53 439-440
  byte   WLKDIF31 441-442
  byte   WLKDIF53 443-444
  byte   MILDIF31 445-446
  byte   MILDIF53 447-448
  byte   STNDIF31 449-450
  byte   STNDIF53 451-452
  byte   BENDIF31 453-454
  byte   BENDIF53 455-456
  byte   RCHDIF31 457-458
  byte   RCHDIF53 459-460
  byte   FNGRDF31 461-462
  byte   FNGRDF53 463-464
  byte   ACTLIM31 465-466
  byte   ACTLIM53 467-468
  byte   WRKLIM31 469-470
  byte   WRKLIM53 471-472
  byte   HSELIM31 473-474
  byte   HSELIM53 475-476
  byte   SCHLIM31 477-478
  byte   SCHLIM53 479-480
  byte   UNABLE31 481-482
  byte   UNABLE53 483-484
  byte   SOCLIM31 485-486
  byte   SOCLIM53 487-488
  byte   COGLIM31 489-490
  byte   COGLIM53 491-492
  byte   DFHEAR42 493-494
  byte   DEAF42 495-496
  byte   DFSEE42 497-498
  byte   BLIND42 499-500
  byte   DFCOG42 501-502
  byte   DFWLKC42 503-504
  byte   DFDRSB42 505-506
  byte   DFERND42 507-508
  byte   HEARAD42 509-510
  byte   WRGLAS42 511-512
  byte   ANYLMT14 513-514
  byte   CHPMED42 515-516
  byte   CHPMHB42 517-518
  byte   CHPMCN42 519-520
  byte   CHSERV42 521-522
  byte   CHSRHB42 523-524
  byte   CHSRCN42 525-526
  byte   CHLIMI42 527-528
  byte   CHLIHB42 529-530
  byte   CHLICO42 531-532
  byte   CHTHER42 533-534
  byte   CHTHHB42 535-536
  byte   CHTHCO42 537-538
  byte   CHCOUN42 539-540
  byte   CHEMPB42 541-542
  byte   CSHCN42 543-544
  byte   MOMPRO42 545-546
  byte   DADPRO42 547-548
  byte   UNHAP42 549-550
  byte   SCHLBH42 551-552
  byte   HAVFUN42 553-554
  byte   ADUPRO42 555-556
  byte   NERVAF42 557-558
  byte   SIBPRO42 559-560
  byte   KIDPRO42 561-562
  byte   SPRPRO42 563-564
  byte   SCHPRO42 565-566
  byte   HOMEBH42 567-568
  byte   TRBLE42 569-570
  byte   CHILCR42 571-572
  byte   CHILWW42 573-574
  byte   CHRTCR42 575-576
  byte   CHRTWW42 577-578
  byte   CHAPPT42 579-580
  byte   CHNDCR42 581-582
  byte   CHENEC42 583-584
  byte   CHLIST42 585-586
  byte   CHEXPL42 587-588
  byte   CHRESP42 589-590
  byte   CHPRTM42 591-592
  byte   CHHECR42 593-594
  byte   CHSPEC42 595-596
  byte   CHEYRE42 597-598
  byte   MESHGT42 599-600
  byte   WHNHGT42 601-602
  byte   MESWGT42 603-604
  byte   WHNWGT42 605-606
  double CHBMIX42 607-611
  byte   MESVIS42 612-613
  byte   MESBPR42 614-615
  byte   WHNBPR42 616-617
  byte   DENTAL42 618-619
  byte   WHNDEN42 620-621
  byte   EATHLT42 622-623
  byte   WHNEAT42 624-625
  byte   PHYSCL42 626-627
  byte   WHNPHY42 628-629
  byte   SAFEST42 630-631
  byte   WHNSAF42 632-633
  byte   BOOST42 634-635
  byte   WHNBST42 636-637
  byte   LAPBLT42 638-639
  byte   WHNLAP42 640-641
  byte   HELMET42 642-643
  byte   WHNHEL42 644-645
  byte   NOSMOK42 646-647
  byte   WHNSMK42 648-649
  byte   TIMALN42 650-651
  byte   DENTCK53 652-653
  byte   BPCHEK53 654-655
  byte   CHOLCK53 656-657
  byte   CHECK53 658-659
  byte   NOFAT53 660-661
  byte   EXRCIS53 662-663
  byte   FLUSHT53 664-665
  byte   ASPRIN53 666-667
  byte   NOASPR53 668-669
  byte   STOMCH53 670-671
  byte   LSTETH53 672-673
  byte   PSA53 674-675
  byte   HYSTER53 676-677
  byte   PAPSMR53 678-679
  byte   BRSTEX53 680-681
  byte   MAMOGR53 682-683
  byte   BSTST53 684-685
  byte   BSTSRE53 686-687
  byte   CLNTST53 688-689
  byte   CLNTRE53 690-691
  byte   SGMTST53 692-693
  byte   SGMTRE53 694-695
  byte   PHYEXE53 696-697
  double BMINDX53 698-702
  byte   SEATBE53 703-704
  byte   SAQELIG 705-705
  int    ADPRX42 706-708
  byte   ADILCR42 709-710
  byte   ADILWW42 711-712
  byte   ADRTCR42 713-714
  byte   ADRTWW42 715-716
  byte   ADAPPT42 717-718
  byte   ADNDCR42 719-720
  byte   ADEGMC42 721-722
  byte   ADLIST42 723-724
  byte   ADEXPL42 725-726
  byte   ADRESP42 727-728
  byte   ADPRTM42 729-730
  byte   ADINST42 731-732
  byte   ADEZUN42 733-734
  byte   ADTLHW42 735-736
  byte   ADFFRM42 737-738
  byte   ADFHLP42 739-740
  byte   ADHECR42 741-742
  byte   ADSMOK42 743-744
  byte   ADNSMK42 745-746
  byte   ADDRBP42 747-748
  byte   ADSPEC42 749-750
  byte   ADESSP42 751-752
  byte   ADGENH42 753-754
  byte   ADDAYA42 755-756
  byte   ADCLIM42 757-758
  byte   ADPALS42 759-760
  byte   ADPWLM42 761-762
  byte   ADMALS42 763-764
  byte   ADMWLM42 765-766
  byte   ADPAIN42 767-768
  byte   ADCAPE42 769-770
  byte   ADNRGY42 771-772
  byte   ADDOWN42 773-774
  byte   ADSOCA42 775-776
  double PCS42 777-781
  double MCS42 782-786
  byte   SFFLAG42 787-788
  byte   ADNERV42 789-790
  byte   ADHOPE42 791-792
  byte   ADREST42 793-794
  byte   ADSAD42 795-796
  byte   ADEFRT42 797-798
  byte   ADWRTH42 799-800
  byte   K6SUM42 801-802
  byte   ADINTR42 803-804
  byte   ADDPRS42 805-806
  byte   PHQ242 807-808
  byte   ADINSA42 809-810
  byte   ADINSB42 811-812
  byte   ADRISK42 813-814
  byte   ADOVER42 815-816
  byte   ADCMPM42 817-818
  int    ADCMPY42 819-822
  byte   ADLANG42 823-824
  byte   DSDIA53 825-826
  byte   DSA1C53 827-828
  byte   DSFT1553 829-830
  byte   DSFT1453 831-832
  byte   DSFT1353 833-834
  byte   DSFB1353 835-836
  byte   DSFTNV53 837-838
  byte   DSEY1553 839-840
  byte   DSEY1453 841-842
  byte   DSEY1353 843-844
  byte   DSEB1353 845-846
  byte   DSEYNV53 847-848
  byte   DSCH1553 849-850
  byte   DSCH1453 851-852
  byte   DSCH1353 853-854
  byte   DSCB1353 855-856
  byte   DSCHNV53 857-858
  byte   DSFL1553 859-860
  byte   DSFL1453 861-862
  byte   DSFL1353 863-864
  byte   DSVB1353 865-866
  byte   DSFLNV53 867-868
  byte   DSKIDN53 869-870
  byte   DSEYPR53 871-872
  byte   DSDIET53 873-874
  byte   DSMED53 875-876
  byte   DSINSU53 877-878
  byte   DSCPCP53 879-880
  byte   DSCNPC53 881-882
  byte   DSCPHN53 883-884
  byte   DSCINT53 885-886
  byte   DSCGRP53 887-888
  byte   DSCONF53 889-890
  byte   DSPRX53 891-892
  int    DDNWRK31 893-895
  int    DDNWRK42 896-898
  int    DDNWRK53 899-901
  byte   DDNSCL31 902-903
  int    DDNSCL42 904-906
  int    DDNSCL53 907-909
  byte   OTHDYS31 910-911
  byte   OTHDYS42 912-913
  byte   OTHDYS53 914-915
  int    OTHNDD31 916-918
  int    OTHNDD42 919-921
  byte   OTHNDD53 922-923
  byte   ACCELI42 924-925
  byte   HAVEUS42 926-927
  byte   YNOUSC42 928-929
  byte   NOREAS42 930-931
  byte   SELDSI42 932-933
  byte   NEWARE42 934-935
  byte   DKWHRU42 936-937
  byte   USCNOT42 938-939
  byte   PERSLA42 940-941
  byte   DIFFPL42 942-943
  byte   INSRPL42 944-945
  byte   MYSELF42 946-947
  byte   CARECO42 948-949
  byte   NOHINS42 950-951
  byte   OTHINS42 952-953
  byte   JOBRSN42 954-955
  byte   NEWDOC42 956-957
  byte   DOCELS42 958-959
  byte   NOLIKE42 960-961
  byte   HEALTH42 962-963
  byte   KNOWDR42 964-965
  byte   ONJOB42 966-967
  byte   NOGODR42 968-969
  byte   TRANS42 970-971
  byte   CLINIC42 972-973
  byte   OTHREA42 974-975
  byte   PROVTY42 976-977
  byte   PLCTYP42 978-979
  byte   TMTKUS42 980-981
  byte   TYPEPE42 982-983
  byte   LOCATN42 984-985
  byte   HSPLAP42 986-987
  byte   WHITPR42 988-989
  byte   BLCKPR42 990-991
  byte   ASIANP42 992-993
  byte   NATAMP42 994-995
  byte   PACISP42 996-997
  byte   OTHRCP42 998-999
  byte   GENDRP42 1000-1001
  byte   MINORP42 1002-1003
  byte   PREVEN42 1004-1005
  byte   REFFRL42 1006-1007
  byte   ONGONG42 1008-1009
  byte   PHNREG42 1010-1011
  byte   OFFHOU42 1012-1013
  byte   AFTHOU42 1014-1015
  byte   TREATM42 1016-1017
  byte   RESPCT42 1018-1019
  byte   DECIDE42 1020-1021
  byte   EXPLOP42 1022-1023
  byte   PRVSPK42 1024-1025
  byte   MDUNAB42 1026-1027
  byte   MDUNRS42 1028-1029
  byte   MDDLAY42 1030-1031
  byte   MDDLRS42 1032-1033
  byte   DNUNAB42 1034-1035
  byte   DNUNRS42 1036-1037
  byte   DNDLAY42 1038-1039
  byte   DNDLRS42 1040-1041
  byte   PMUNAB42 1042-1043
  byte   PMUNRS42 1044-1045
  byte   PMDLAY42 1046-1047
  byte   PMDLRS42 1048-1049
  byte   RNDFLG31 1050-1051
  byte   MORJOB31 1052-1053
  byte   MORJOB42 1054-1055
  byte   MORJOB53 1056-1057
  byte   EVRWRK 1058-1059
  double HRWG31X 1060-1065
  double HRWG42X 1066-1071
  double HRWG53X 1072-1077
  byte   HRWGIM31 1078-1078
  byte   HRWGIM42 1079-1079
  byte   HRWGIM53 1080-1080
  byte   HRHOW31 1081-1082
  byte   HRHOW42 1083-1084
  byte   HRHOW53 1085-1086
  byte   DIFFWG31 1087-1088
  byte   DIFFWG42 1089-1090
  byte   DIFFWG53 1091-1092
  double NHRWG31 1093-1098
  double NHRWG42 1099-1104
  double NHRWG53 1105-1110
  int    HOUR31 1111-1113
  int    HOUR42 1114-1116
  int    HOUR53 1117-1119
  byte   TEMPJB31 1120-1121
  byte   TEMPJB42 1122-1123
  byte   TEMPJB53 1124-1125
  byte   SSNLJB31 1126-1127
  byte   SSNLJB42 1128-1129
  byte   SSNLJB53 1130-1131
  byte   SELFCM31 1132-1133
  byte   SELFCM42 1134-1135
  byte   SELFCM53 1136-1137
  byte   DISVW31X 1138-1139
  byte   DISVW42X 1140-1141
  byte   DISVW53X 1142-1143
  byte   CHOIC31 1144-1145
  byte   CHOIC42 1146-1147
  byte   CHOIC53 1148-1149
  byte   INDCAT31 1150-1151
  byte   INDCAT42 1152-1153
  byte   INDCAT53 1154-1155
  int    NUMEMP31 1156-1158
  int    NUMEMP42 1159-1161
  int    NUMEMP53 1162-1164
  byte   MORE31 1165-1166
  byte   MORE42 1167-1168
  byte   MORE53 1169-1170
  byte   UNION31 1171-1172
  byte   UNION42 1173-1174
  byte   UNION53 1175-1176
  byte   NWK31 1177-1178
  byte   NWK42 1179-1180
  byte   NWK53 1181-1182
  byte   CHGJ3142 1183-1184
  byte   CHGJ4253 1185-1186
  byte   YCHJ3142 1187-1188
  byte   YCHJ4253 1189-1190
  byte   STJBMM31 1191-1192
  int    STJBYY31 1193-1196
  byte   STJBMM42 1197-1198
  int    STJBYY42 1199-1202
  byte   STJBMM53 1203-1204
  int    STJBYY53 1205-1208
  byte   EVRETIRE 1209-1210
  byte   OCCCAT31 1211-1212
  byte   OCCCAT42 1213-1214
  byte   OCCCAT53 1215-1216
  byte   PAYVAC31 1217-1218
  byte   PAYVAC42 1219-1220
  byte   PAYVAC53 1221-1222
  byte   SICPAY31 1223-1224
  byte   SICPAY42 1225-1226
  byte   SICPAY53 1227-1228
  byte   PAYDR31 1229-1230
  byte   PAYDR42 1231-1232
  byte   PAYDR53 1233-1234
  byte   RETPLN31 1235-1236
  byte   RETPLN42 1237-1238
  byte   RETPLN53 1239-1240
  byte   BSNTY31 1241-1242
  byte   BSNTY42 1243-1244
  byte   BSNTY53 1245-1246
  byte   JOBORG31 1247-1248
  byte   JOBORG42 1249-1250
  byte   JOBORG53 1251-1252
  byte   HELD31X 1253-1254
  byte   HELD42X 1255-1256
  byte   HELD53X 1257-1258
  byte   OFFER31X 1259-1260
  byte   OFFER42X 1261-1262
  byte   OFFER53X 1263-1264
  byte   OFREMP31 1265-1266
  byte   OFREMP42 1267-1268
  byte   OFREMP53 1269-1270
  byte   EMPST31 1271-1272
  byte   EMPST42 1273-1274
  byte   EMPST53 1275-1276
  byte   EMPST31H 1277-1278
  byte   EMPST42H 1279-1280
  byte   EMPST53H 1281-1282
  byte   SLFCM31H 1283-1284
  byte   SLFCM42H 1285-1286
  byte   SLFCM53H 1287-1288
  int    NMEMP31H 1289-1291
  int    NMEMP42H 1292-1294
  int    NMEMP53H 1295-1297
  byte   MORE31H 1298-1299
  byte   MORE42H 1300-1301
  byte   MORE53H 1302-1303
  byte   INDCT31H 1304-1305
  byte   INDCT42H 1306-1307
  byte   INDCT53H 1308-1309
  byte   OCCCT31H 1310-1311
  byte   OCCCT42H 1312-1313
  byte   OCCCT53H 1314-1315
  int    HOUR31H 1316-1318
  int    HOUR42H 1319-1321
  int    HOUR53H 1322-1324
  byte   JBORG31H 1325-1326
  byte   JBORG42H 1327-1328
  byte   JBORG53H 1329-1330
  byte   UNION31H 1331-1332
  byte   UNION42H 1333-1334
  byte   UNION53H 1335-1336
  byte   BSNTY31H 1337-1338
  byte   BSNTY42H 1339-1340
  byte   BSNTY53H 1341-1342
  double HRWG31H 1343-1348
  double HRWG42H 1349-1354
  double HRWG53H 1355-1360
  byte   CMJHLD31 1361-1362
  byte   CMJHLD42 1363-1364
  byte   CMJHLD53 1365-1366
  byte   OFFER31H 1367-1368
  byte   OFFER42H 1369-1370
  byte   OFFER53H 1371-1372
  byte   OFEMP31H 1373-1374
  byte   OFEMP42H 1375-1376
  byte   OFEMP53H 1377-1378
  byte   PYVAC31H 1379-1380
  byte   PYVAC42H 1381-1382
  byte   PYVAC53H 1383-1384
  byte   SCPAY31H 1385-1386
  byte   SCPAY42H 1387-1388
  byte   SCPAY53H 1389-1390
  byte   PAYDR31H 1391-1392
  byte   PAYDR42H 1393-1394
  byte   PAYDR53H 1395-1396
  byte   RTPLN31H 1397-1398
  byte   RTPLN42H 1399-1400
  byte   RTPLN53H 1401-1402
  byte   AFDC14 1403-1404
  byte   FILEDR14 1405-1406
  byte   WILFIL14 1407-1408
  byte   FLSTAT14 1409-1410
  byte   FILER14 1411-1412
  byte   JTINRU14 1413-1414
  int    JNTPID14 1415-1417
  byte   CLMDEP14 1418-1419
  byte   DEPDNT14 1420-1421
  byte   DPINRU14 1422-1423
  byte   DPOTSD14 1424-1425
  byte   TAXFRM14 1426-1427
  byte   CLMHIP14 1428-1429
  byte   EICRDT14 1430-1431
  byte   FOODST14 1432-1433
  byte   FOODMN14 1434-1435
  int    FOODVL14 1436-1439
  long   TTLP14X 1440-1446
  long   FAMINC14 1447-1452
  byte   POVCAT14 1453-1453
  double POVLEV14 1454-1464
  long   WAGEP14X 1465-1470
  byte   WAGIMP14 1471-1471
  long   BUSNP14X 1472-1478
  byte   BUSIMP14 1479-1479
  long   UNEMP14X 1480-1484
  byte   UNEIMP14 1485-1485
  long   WCMPP14X 1486-1490
  byte   WCPIMP14 1491-1491
  long   INTRP14X 1492-1496
  byte   INTIMP14 1497-1497
  long   DIVDP14X 1498-1503
  byte   DIVIMP14 1504-1504
  long   SALEP14X 1505-1511
  byte   SALIMP14 1512-1512
  long   PENSP14X 1513-1517
  byte   PENIMP14 1518-1518
  long   SSECP14X 1519-1523
  byte   SSCIMP14 1524-1524
  long   TRSTP14X 1525-1530
  byte   TRTIMP14 1531-1531
  long   VETSP14X 1532-1536
  byte   VETIMP14 1537-1537
  long   IRASP14X 1538-1543
  byte   IRAIMP14 1544-1544
  long   ALIMP14X 1545-1549
  byte   ALIIMP14 1550-1550
  long   CHLDP14X 1551-1555
  byte   CHLIMP14 1556-1556
  long   CASHP14X 1557-1562
  byte   CSHIMP14 1563-1563
  long   SSIP14X 1564-1568
  byte   SSIIMP14 1569-1569
  int    PUBP14X 1570-1573
  byte   PUBIMP14 1574-1574
  long   OTHRP14X 1575-1580
  byte   OTHIMP14 1581-1581
  str    HIEUIDX 1582-1588
  byte   TRIJA14X 1589-1590
  byte   TRIFE14X 1591-1592
  byte   TRIMA14X 1593-1594
  byte   TRIAP14X 1595-1596
  byte   TRIMY14X 1597-1598
  byte   TRIJU14X 1599-1600
  byte   TRIJL14X 1601-1602
  byte   TRIAU14X 1603-1604
  byte   TRISE14X 1605-1606
  byte   TRIOC14X 1607-1608
  byte   TRINO14X 1609-1610
  byte   TRIDE14X 1611-1612
  byte   MCRJA14 1613-1614
  byte   MCRFE14 1615-1616
  byte   MCRMA14 1617-1618
  byte   MCRAP14 1619-1620
  byte   MCRMY14 1621-1622
  byte   MCRJU14 1623-1624
  byte   MCRJL14 1625-1626
  byte   MCRAU14 1627-1628
  byte   MCRSE14 1629-1630
  byte   MCROC14 1631-1632
  byte   MCRNO14 1633-1634
  byte   MCRDE14 1635-1636
  byte   MCRJA14X 1637-1638
  byte   MCRFE14X 1639-1640
  byte   MCRMA14X 1641-1642
  byte   MCRAP14X 1643-1644
  byte   MCRMY14X 1645-1646
  byte   MCRJU14X 1647-1648
  byte   MCRJL14X 1649-1650
  byte   MCRAU14X 1651-1652
  byte   MCRSE14X 1653-1654
  byte   MCROC14X 1655-1656
  byte   MCRNO14X 1657-1658
  byte   MCRDE14X 1659-1660
  byte   MCDJA14 1661-1662
  byte   MCDFE14 1663-1664
  byte   MCDMA14 1665-1666
  byte   MCDAP14 1667-1668
  byte   MCDMY14 1669-1670
  byte   MCDJU14 1671-1672
  byte   MCDJL14 1673-1674
  byte   MCDAU14 1675-1676
  byte   MCDSE14 1677-1678
  byte   MCDOC14 1679-1680
  byte   MCDNO14 1681-1682
  byte   MCDDE14 1683-1684
  byte   MCDJA14X 1685-1686
  byte   MCDFE14X 1687-1688
  byte   MCDMA14X 1689-1690
  byte   MCDAP14X 1691-1692
  byte   MCDMY14X 1693-1694
  byte   MCDJU14X 1695-1696
  byte   MCDJL14X 1697-1698
  byte   MCDAU14X 1699-1700
  byte   MCDSE14X 1701-1702
  byte   MCDOC14X 1703-1704
  byte   MCDNO14X 1705-1706
  byte   MCDDE14X 1707-1708
  byte   OPAJA14 1709-1710
  byte   OPAFE14 1711-1712
  byte   OPAMA14 1713-1714
  byte   OPAAP14 1715-1716
  byte   OPAMY14 1717-1718
  byte   OPAJU14 1719-1720
  byte   OPAJL14 1721-1722
  byte   OPAAU14 1723-1724
  byte   OPASE14 1725-1726
  byte   OPAOC14 1727-1728
  byte   OPANO14 1729-1730
  byte   OPADE14 1731-1732
  byte   OPBJA14 1733-1734
  byte   OPBFE14 1735-1736
  byte   OPBMA14 1737-1738
  byte   OPBAP14 1739-1740
  byte   OPBMY14 1741-1742
  byte   OPBJU14 1743-1744
  byte   OPBJL14 1745-1746
  byte   OPBAU14 1747-1748
  byte   OPBSE14 1749-1750
  byte   OPBOC14 1751-1752
  byte   OPBNO14 1753-1754
  byte   OPBDE14 1755-1756
  byte   STAJA14 1757-1758
  byte   STAFE14 1759-1760
  byte   STAMA14 1761-1762
  byte   STAAP14 1763-1764
  byte   STAMY14 1765-1766
  byte   STAJU14 1767-1768
  byte   STAJL14 1769-1770
  byte   STAAU14 1771-1772
  byte   STASE14 1773-1774
  byte   STAOC14 1775-1776
  byte   STANO14 1777-1778
  byte   STADE14 1779-1780
  byte   PUBJA14X 1781-1782
  byte   PUBFE14X 1783-1784
  byte   PUBMA14X 1785-1786
  byte   PUBAP14X 1787-1788
  byte   PUBMY14X 1789-1790
  byte   PUBJU14X 1791-1792
  byte   PUBJL14X 1793-1794
  byte   PUBAU14X 1795-1796
  byte   PUBSE14X 1797-1798
  byte   PUBOC14X 1799-1800
  byte   PUBNO14X 1801-1802
  byte   PUBDE14X 1803-1804
  byte   PEGJA14 1805-1806
  byte   PEGFE14 1807-1808
  byte   PEGMA14 1809-1810
  byte   PEGAP14 1811-1812
  byte   PEGMY14 1813-1814
  byte   PEGJU14 1815-1816
  byte   PEGJL14 1817-1818
  byte   PEGAU14 1819-1820
  byte   PEGSE14 1821-1822
  byte   PEGOC14 1823-1824
  byte   PEGNO14 1825-1826
  byte   PEGDE14 1827-1828
  byte   PDKJA14 1829-1830
  byte   PDKFE14 1831-1832
  byte   PDKMA14 1833-1834
  byte   PDKAP14 1835-1836
  byte   PDKMY14 1837-1838
  byte   PDKJU14 1839-1840
  byte   PDKJL14 1841-1842
  byte   PDKAU14 1843-1844
  byte   PDKSE14 1845-1846
  byte   PDKOC14 1847-1848
  byte   PDKNO14 1849-1850
  byte   PDKDE14 1851-1852
  byte   PNGJA14 1853-1854
  byte   PNGFE14 1855-1856
  byte   PNGMA14 1857-1858
  byte   PNGAP14 1859-1860
  byte   PNGMY14 1861-1862
  byte   PNGJU14 1863-1864
  byte   PNGJL14 1865-1866
  byte   PNGAU14 1867-1868
  byte   PNGSE14 1869-1870
  byte   PNGOC14 1871-1872
  byte   PNGNO14 1873-1874
  byte   PNGDE14 1875-1876
  byte   POGJA14 1877-1878
  byte   POGFE14 1879-1880
  byte   POGMA14 1881-1882
  byte   POGAP14 1883-1884
  byte   POGMY14 1885-1886
  byte   POGJU14 1887-1888
  byte   POGJL14 1889-1890
  byte   POGAU14 1891-1892
  byte   POGSE14 1893-1894
  byte   POGOC14 1895-1896
  byte   POGNO14 1897-1898
  byte   POGDE14 1899-1900
  byte   PRSJA14 1901-1902
  byte   PRSFE14 1903-1904
  byte   PRSMA14 1905-1906
  byte   PRSAP14 1907-1908
  byte   PRSMY14 1909-1910
  byte   PRSJU14 1911-1912
  byte   PRSJL14 1913-1914
  byte   PRSAU14 1915-1916
  byte   PRSSE14 1917-1918
  byte   PRSOC14 1919-1920
  byte   PRSNO14 1921-1922
  byte   PRSDE14 1923-1924
  byte   POUJA14 1925-1926
  byte   POUFE14 1927-1928
  byte   POUMA14 1929-1930
  byte   POUAP14 1931-1932
  byte   POUMY14 1933-1934
  byte   POUJU14 1935-1936
  byte   POUJL14 1937-1938
  byte   POUAU14 1939-1940
  byte   POUSE14 1941-1942
  byte   POUOC14 1943-1944
  byte   POUNO14 1945-1946
  byte   POUDE14 1947-1948
  byte   PRXJA14 1949-1950
  byte   PRXFE14 1951-1952
  byte   PRXMA14 1953-1954
  byte   PRXAP14 1955-1956
  byte   PRXMY14 1957-1958
  byte   PRXJU14 1959-1960
  byte   PRXJL14 1961-1962
  byte   PRXAU14 1963-1964
  byte   PRXSE14 1965-1966
  byte   PRXOC14 1967-1968
  byte   PRXNO14 1969-1970
  byte   PRXDE14 1971-1972
  byte   PRIJA14 1973-1974
  byte   PRIFE14 1975-1976
  byte   PRIMA14 1977-1978
  byte   PRIAP14 1979-1980
  byte   PRIMY14 1981-1982
  byte   PRIJU14 1983-1984
  byte   PRIJL14 1985-1986
  byte   PRIAU14 1987-1988
  byte   PRISE14 1989-1990
  byte   PRIOC14 1991-1992
  byte   PRINO14 1993-1994
  byte   PRIDE14 1995-1996
  byte   HPEJA14 1997-1998
  byte   HPEFE14 1999-2000
  byte   HPEMA14 2001-2002
  byte   HPEAP14 2003-2004
  byte   HPEMY14 2005-2006
  byte   HPEJU14 2007-2008
  byte   HPEJL14 2009-2010
  byte   HPEAU14 2011-2012
  byte   HPESE14 2013-2014
  byte   HPEOC14 2015-2016
  byte   HPENO14 2017-2018
  byte   HPEDE14 2019-2020
  byte   HPDJA14 2021-2022
  byte   HPDFE14 2023-2024
  byte   HPDMA14 2025-2026
  byte   HPDAP14 2027-2028
  byte   HPDMY14 2029-2030
  byte   HPDJU14 2031-2032
  byte   HPDJL14 2033-2034
  byte   HPDAU14 2035-2036
  byte   HPDSE14 2037-2038
  byte   HPDOC14 2039-2040
  byte   HPDNO14 2041-2042
  byte   HPDDE14 2043-2044
  byte   HPNJA14 2045-2046
  byte   HPNFE14 2047-2048
  byte   HPNMA14 2049-2050
  byte   HPNAP14 2051-2052
  byte   HPNMY14 2053-2054
  byte   HPNJU14 2055-2056
  byte   HPNJL14 2057-2058
  byte   HPNAU14 2059-2060
  byte   HPNSE14 2061-2062
  byte   HPNOC14 2063-2064
  byte   HPNNO14 2065-2066
  byte   HPNDE14 2067-2068
  byte   HPOJA14 2069-2070
  byte   HPOFE14 2071-2072
  byte   HPOMA14 2073-2074
  byte   HPOAP14 2075-2076
  byte   HPOMY14 2077-2078
  byte   HPOJU14 2079-2080
  byte   HPOJL14 2081-2082
  byte   HPOAU14 2083-2084
  byte   HPOSE14 2085-2086
  byte   HPOOC14 2087-2088
  byte   HPONO14 2089-2090
  byte   HPODE14 2091-2092
  byte   HPSJA14 2093-2094
  byte   HPSFE14 2095-2096
  byte   HPSMA14 2097-2098
  byte   HPSAP14 2099-2100
  byte   HPSMY14 2101-2102
  byte   HPSJU14 2103-2104
  byte   HPSJL14 2105-2106
  byte   HPSAU14 2107-2108
  byte   HPSSE14 2109-2110
  byte   HPSOC14 2111-2112
  byte   HPSNO14 2113-2114
  byte   HPSDE14 2115-2116
  byte   HPXJA14 2117-2118
  byte   HPXFE14 2119-2120
  byte   HPXMA14 2121-2122
  byte   HPXAP14 2123-2124
  byte   HPXMY14 2125-2126
  byte   HPXJU14 2127-2128
  byte   HPXJL14 2129-2130
  byte   HPXAU14 2131-2132
  byte   HPXSE14 2133-2134
  byte   HPXOC14 2135-2136
  byte   HPXNO14 2137-2138
  byte   HPXDE14 2139-2140
  byte   HPRJA14 2141-2142
  byte   HPRFE14 2143-2144
  byte   HPRMA14 2145-2146
  byte   HPRAP14 2147-2148
  byte   HPRMY14 2149-2150
  byte   HPRJU14 2151-2152
  byte   HPRJL14 2153-2154
  byte   HPRAU14 2155-2156
  byte   HPRSE14 2157-2158
  byte   HPROC14 2159-2160
  byte   HPRNO14 2161-2162
  byte   HPRDE14 2163-2164
  byte   INSJA14X 2165-2166
  byte   INSFE14X 2167-2168
  byte   INSMA14X 2169-2170
  byte   INSAP14X 2171-2172
  byte   INSMY14X 2173-2174
  byte   INSJU14X 2175-2176
  byte   INSJL14X 2177-2178
  byte   INSAU14X 2179-2180
  byte   INSSE14X 2181-2182
  byte   INSOC14X 2183-2184
  byte   INSNO14X 2185-2186
  byte   INSDE14X 2187-2188
  byte   PRVEV14 2189-2189
  byte   TRIEV14 2190-2190
  byte   MCREV14 2191-2191
  byte   MCDEV14 2192-2192
  byte   OPAEV14 2193-2193
  byte   OPBEV14 2194-2194
  byte   UNINS14 2195-2195
  byte   INSCOV14 2196-2196
  byte   INSURC14 2197-2197
  byte   TRIST31X 2198-2199
  byte   TRIST42X 2200-2201
  byte   TRIST14X 2202-2203
  byte   TRIPR31X 2204-2205
  byte   TRIPR42X 2206-2207
  byte   TRIPR14X 2208-2209
  byte   TRIEX31X 2210-2211
  byte   TRIEX42X 2212-2213
  byte   TRIEX14X 2214-2215
  byte   TRILI31X 2216-2217
  byte   TRILI42X 2218-2219
  byte   TRILI14X 2220-2221
  byte   TRICH31X 2222-2223
  byte   TRICH42X 2224-2225
  byte   TRICH14X 2226-2227
  byte   MCRPD31 2228-2229
  byte   MCRPD42 2230-2231
  byte   MCRPD14 2232-2233
  byte   MCRPD31X 2234-2235
  byte   MCRPD42X 2236-2237
  byte   MCRPD14X 2238-2239
  byte   MCRPB31 2240-2241
  byte   MCRPB42 2242-2243
  byte   MCRPB14 2244-2245
  byte   MCRPHO31 2246-2247
  byte   MCRPHO42 2248-2249
  byte   MCRPHO14 2250-2251
  byte   MCDHMO31 2252-2253
  byte   MCDHMO42 2254-2255
  byte   MCDHMO14 2256-2257
  byte   MCDMC31 2258-2259
  byte   MCDMC42 2260-2261
  byte   MCDMC14 2262-2263
  byte   PRVHMO31 2264-2265
  byte   PRVHMO42 2266-2267
  byte   PRVHMO14 2268-2269
  byte   FSAGT31 2270-2271
  byte   HASFSA31 2272-2273
  double FSAAMT31 2274-2280
  byte   PROBPY42 2281-2282
  byte   CRFMPY42 2283-2284
  byte   PYUNBL42 2285-2286
  byte   PREVCOVR 2287-2288
  byte   COVRMM 2289-2290
  int    COVRYY 2291-2294
  byte   WASESTB 2295-2296
  byte   WASMCARE 2297-2298
  byte   WASMCAID 2299-2300
  byte   WASCHAMP 2301-2302
  byte   WASVA 2303-2304
  byte   WASPRIV 2305-2306
  byte   WASOTGOV 2307-2308
  byte   WASAFDC 2309-2310
  byte   WASSSI 2311-2312
  byte   WASSTAT1 2313-2314
  byte   WASSTAT2 2315-2316
  byte   WASSTAT3 2317-2318
  byte   WASSTAT4 2319-2320
  byte   WASOTHER 2321-2322
  byte   NOINSBEF 2323-2324
  byte   NOINSTM 2325-2326
  byte   NOINUNIT 2327-2328
  byte   MORECOVR 2329-2330
  byte   INSENDMM 2331-2332
  int    INSENDYY 2333-2336
  byte   TRICR31X 2337-2338
  byte   TRICR42X 2339-2340
  byte   TRICR53X 2341-2342
  byte   TRICR14X 2343-2344
  byte   TRIAT31X 2345-2346
  byte   TRIAT42X 2347-2348
  byte   TRIAT53X 2349-2350
  byte   TRIAT14X 2351-2352
  byte   MCAID31 2353-2354
  byte   MCAID42 2355-2356
  byte   MCAID53 2357-2358
  byte   MCAID14 2359-2360
  byte   MCAID31X 2361-2362
  byte   MCAID42X 2363-2364
  byte   MCAID53X 2365-2366
  byte   MCAID14X 2367-2368
  byte   MCARE31 2369-2370
  byte   MCARE42 2371-2372
  byte   MCARE53 2373-2374
  byte   MCARE14 2375-2376
  byte   MCARE31X 2377-2378
  byte   MCARE42X 2379-2380
  byte   MCARE53X 2381-2382
  byte   MCARE14X 2383-2384
  byte   MCDAT31X 2385-2386
  byte   MCDAT42X 2387-2388
  byte   MCDAT53X 2389-2390
  byte   MCDAT14X 2391-2392
  byte   OTPAAT31 2393-2394
  byte   OTPAAT42 2395-2396
  byte   OTPAAT53 2397-2398
  byte   OTPAAT14 2399-2400
  byte   OTPBAT31 2401-2402
  byte   OTPBAT42 2403-2404
  byte   OTPBAT53 2405-2406
  byte   OTPBAT14 2407-2408
  byte   OTPUBA31 2409-2410
  byte   OTPUBA42 2411-2412
  byte   OTPUBA53 2413-2414
  byte   OTPUBA14 2415-2416
  byte   OTPUBB31 2417-2418
  byte   OTPUBB42 2419-2420
  byte   OTPUBB53 2421-2422
  byte   OTPUBB14 2423-2424
  byte   PRIDK31 2425-2426
  byte   PRIDK42 2427-2428
  byte   PRIDK53 2429-2430
  byte   PRIDK14 2431-2432
  byte   PRIEU31 2433-2434
  byte   PRIEU42 2435-2436
  byte   PRIEU53 2437-2438
  byte   PRIEU14 2439-2440
  byte   PRING31 2441-2442
  byte   PRING42 2443-2444
  byte   PRING53 2445-2446
  byte   PRING14 2447-2448
  byte   PRIOG31 2449-2450
  byte   PRIOG42 2451-2452
  byte   PRIOG53 2453-2454
  byte   PRIOG14 2455-2456
  byte   PRIS31 2457-2458
  byte   PRIS42 2459-2460
  byte   PRIS53 2461-2462
  byte   PRIS14 2463-2464
  byte   PROUT31 2465-2466
  byte   PROUT42 2467-2468
  byte   PROUT53 2469-2470
  byte   PROUT14 2471-2472
  byte   PRSTX31 2473-2474
  byte   PRSTX42 2475-2476
  byte   PRSTX53 2477-2478
  byte   PRSTX14 2479-2480
  byte   PRIV31 2481-2482
  byte   PRIV42 2483-2484
  byte   PRIV53 2485-2486
  byte   PRIV14 2487-2488
  byte   PRIVAT31 2489-2490
  byte   PRIVAT42 2491-2492
  byte   PRIVAT53 2493-2494
  byte   PRIVAT14 2495-2496
  byte   PUB31X 2497-2498
  byte   PUB42X 2499-2500
  byte   PUB53X 2501-2502
  byte   PUB14X 2503-2504
  byte   PUBAT31X 2505-2506
  byte   PUBAT42X 2507-2508
  byte   PUBAT53X 2509-2510
  byte   PUBAT14X 2511-2512
  byte   INS31X 2513-2514
  byte   INS42X 2515-2516
  byte   INS53X 2517-2518
  byte   INS14X 2519-2520
  byte   INSAT31X 2521-2522
  byte   INSAT42X 2523-2524
  byte   INSAT53X 2525-2526
  byte   INSAT14X 2527-2528
  byte   STAPR31 2529-2530
  byte   STAPR42 2531-2532
  byte   STAPR53 2533-2534
  byte   STAPR14 2535-2536
  byte   STPRAT31 2537-2538
  byte   STPRAT42 2539-2540
  byte   STPRAT53 2541-2542
  byte   STPRAT14 2543-2544
  byte   DENTIN31 2545-2546
  byte   DENTIN42 2547-2548
  byte   DENTIN53 2549-2550
  byte   DNTINS31 2551-2552
  byte   DNTINS14 2553-2554
  byte   PMEDIN31 2555-2556
  byte   PMEDIN42 2557-2558
  byte   PMEDIN53 2559-2560
  byte   PMDINS31 2561-2562
  byte   PMDINS14 2563-2564
  byte   PMEDUP31 2565-2566
  byte   PMEDUP42 2567-2568
  byte   PMEDUP53 2569-2570
  byte   PMEDPY31 2571-2572
  byte   PMEDPY42 2573-2574
  byte   PMEDPY53 2575-2576
  long   TOTTCH14 2577-2583
  long   TOTEXP14 2584-2589
  long   TOTSLF14 2590-2594
  long   TOTMCR14 2595-2600
  long   TOTMCD14 2601-2606
  long   TOTPRV14 2607-2612
  long   TOTVA14 2613-2618
  long   TOTTRI14 2619-2623
  long   TOTOFD14 2624-2628
  long   TOTSTL14 2629-2633
  long   TOTWCP14 2634-2638
  long   TOTOPR14 2639-2644
  long   TOTOPU14 2645-2650
  long   TOTOSR14 2651-2656
  long   TOTPTR14 2657-2662
  long   TOTOTH14 2663-2668
  int    OBTOTV14 2669-2671
  long   OBVTCH14 2672-2677
  long   OBVEXP14 2678-2683
  long   OBVSLF14 2684-2688
  long   OBVMCR14 2689-2694
  long   OBVMCD14 2695-2699
  long   OBVPRV14 2700-2705
  long   OBVVA14 2706-2710
  long   OBVTRI14 2711-2715
  int    OBVOFD14 2716-2719
  long   OBVSTL14 2720-2724
  long   OBVWCP14 2725-2729
  long   OBVOPR14 2730-2734
  int    OBVOPU14 2735-2738
  long   OBVOSR14 2739-2743
  long   OBVPTR14 2744-2749
  long   OBVOTH14 2750-2754
  int    OBDRV14 2755-2757
  long   OBDTCH14 2758-2763
  long   OBDEXP14 2764-2769
  long   OBDSLF14 2770-2774
  long   OBDMCR14 2775-2780
  long   OBDMCD14 2781-2785
  long   OBDPRV14 2786-2791
  long   OBDVA14 2792-2796
  long   OBDTRI14 2797-2801
  int    OBDOFD14 2802-2805
  long   OBDSTL14 2806-2810
  long   OBDWCP14 2811-2815
  long   OBDOPR14 2816-2820
  int    OBDOPU14 2821-2824
  long   OBDOSR14 2825-2829
  long   OBDPTR14 2830-2835
  long   OBDOTH14 2836-2840
  int    OBOTHV14 2841-2843
  long   OBOTCH14 2844-2849
  long   OBOEXP14 2850-2854
  long   OBOSLF14 2855-2859
  long   OBOMCR14 2860-2864
  long   OBOMCD14 2865-2869
  long   OBOPRV14 2870-2874
  long   OBOVA14 2875-2879
  long   OBOTRI14 2880-2884
  int    OBOOFD14 2885-2888
  long   OBOSTL14 2889-2893
  long   OBOWCP14 2894-2898
  long   OBOOPR14 2899-2903
  int    OBOOPU14 2904-2907
  long   OBOOSR14 2908-2912
  long   OBOPTR14 2913-2917
  long   OBOOTH14 2918-2922
  int    OBCHIR14 2923-2925
  long   OBCTCH14 2926-2930
  long   OBCEXP14 2931-2935
  long   OBCSLF14 2936-2940
  int    OBCMCR14 2941-2944
  int    OBCMCD14 2945-2948
  long   OBCPRV14 2949-2953
  int    OBCVA14 2954-2957
  int    OBCTRI14 2958-2960
  int    OBCOFD14 2961-2964
  int    OBCSTL14 2965-2968
  long   OBCWCP14 2969-2973
  long   OBCOPR14 2974-2978
  int    OBCOPU14 2979-2981
  long   OBCOSR14 2982-2986
  long   OBCPTR14 2987-2991
  long   OBCOTH14 2992-2996
  int    OBNURS14 2997-2999
  long   OBNTCH14 3000-3005
  long   OBNEXP14 3006-3010
  long   OBNSLF14 3011-3015
  long   OBNMCR14 3016-3020
  long   OBNMCD14 3021-3025
  long   OBNPRV14 3026-3030
  int    OBNVA14 3031-3034
  long   OBNTRI14 3035-3039
  int    OBNOFD14 3040-3043
  int    OBNSTL14 3044-3047
  int    OBNWCP14 3048-3050
  long   OBNOPR14 3051-3055
  int    OBNOPU14 3056-3058
  int    OBNOSR14 3059-3062
  long   OBNPTR14 3063-3067
  long   OBNOTH14 3068-3072
  byte   OBOPTO14 3073-3074
  int    OBETCH14 3075-3078
  int    OBEEXP14 3079-3082
  int    OBESLF14 3083-3086
  int    OBEMCR14 3087-3089
  int    OBEMCD14 3090-3092
  int    OBEPRV14 3093-3096
  int    OBEVA14 3097-3099
  int    OBETRI14 3100-3102
  int    OBEOFD14 3103-3105
  int    OBESTL14 3106-3109
  int    OBEWCP14 3110-3112
  int    OBEOPR14 3113-3115
  int    OBEOPU14 3116-3118
  int    OBEOSR14 3119-3121
  int    OBEPTR14 3122-3125
  int    OBEOTH14 3126-3129
  byte   OBASST14 3130-3131
  long   OBATCH14 3132-3136
  long   OBAEXP14 3137-3141
  int    OBASLF14 3142-3145
  int    OBAMCR14 3146-3149
  long   OBAMCD14 3150-3154
  int    OBAPRV14 3155-3158
  int    OBAVA14 3159-3162
  int    OBATRI14 3163-3166
  int    OBAOFD14 3167-3170
  int    OBASTL14 3171-3174
  int    OBAWCP14 3175-3177
  int    OBAOPR14 3178-3180
  int    OBAOPU14 3181-3183
  int    OBAOSR14 3184-3187
  int    OBAPTR14 3188-3191
  int    OBAOTH14 3192-3195
  int    OBTHER14 3196-3198
  long   OBTTCH14 3199-3203
  long   OBTEXP14 3204-3208
  int    OBTSLF14 3209-3212
  long   OBTMCR14 3213-3217
  long   OBTMCD14 3218-3222
  long   OBTPRV14 3223-3227
  long   OBTVA14 3228-3232
  long   OBTTRI14 3233-3237
  int    OBTOFD14 3238-3241
  int    OBTSTL14 3242-3245
  long   OBTWCP14 3246-3250
  int    OBTOPR14 3251-3254
  int    OBTOPU14 3255-3258
  int    OBTOSR14 3259-3262
  long   OBTPTR14 3263-3267
  int    OBTOTH14 3268-3271
  int    OPTOTV14 3272-3274
  long   OPTTCH14 3275-3281
  long   OPTEXP14 3282-3287
  long   OPTSLF14 3288-3292
  long   OPTMCR14 3293-3298
  long   OPTMCD14 3299-3304
  long   OPTPRV14 3305-3310
  long   OPTVA14 3311-3316
  int    OPTTRI14 3317-3320
  long   OPTOFD14 3321-3325
  long   OPTSTL14 3326-3330
  long   OPTWCP14 3331-3335
  long   OPTOPR14 3336-3341
  long   OPTOPU14 3342-3346
  long   OPTOSR14 3347-3351
  long   OPTPTR14 3352-3357
  long   OPTOTH14 3358-3363
  long   OPFTCH14 3364-3370
  long   OPFEXP14 3371-3376
  long   OPFSLF14 3377-3381
  long   OPFMCR14 3382-3387
  long   OPFMCD14 3388-3393
  long   OPFPRV14 3394-3399
  long   OPFVA14 3400-3405
  int    OPFTRI14 3406-3409
  long   OPFOFD14 3410-3414
  long   OPFSTL14 3415-3419
  long   OPFWCP14 3420-3424
  long   OPFOPR14 3425-3430
  long   OPFOPU14 3431-3435
  long   OPFOSR14 3436-3440
  long   OPFPTR14 3441-3446
  long   OPFOTH14 3447-3452
  long   OPDEXP14 3453-3457
  long   OPDTCH14 3458-3463
  int    OPDSLF14 3464-3467
  long   OPDMCR14 3468-3472
  long   OPDMCD14 3473-3477
  long   OPDPRV14 3478-3482
  int    OPDVA14 3483-3486
  int    OPDTRI14 3487-3490
  byte   OPDOFD14 3491-3492
  int    OPDSTL14 3493-3495
  int    OPDWCP14 3496-3499
  long   OPDOPR14 3500-3504
  long   OPDOPU14 3505-3509
  int    OPDOSR14 3510-3513
  long   OPDPTR14 3514-3518
  long   OPDOTH14 3519-3523
  int    OPDRV14 3524-3526
  long   OPVTCH14 3527-3532
  long   OPVEXP14 3533-3538
  long   OPVSLF14 3539-3543
  long   OPVMCR14 3544-3549
  long   OPVMCD14 3550-3554
  long   OPVPRV14 3555-3560
  long   OPVVA14 3561-3565
  int    OPVTRI14 3566-3569
  long   OPVOFD14 3570-3574
  long   OPVSTL14 3575-3579
  long   OPVWCP14 3580-3584
  long   OPVOPR14 3585-3590
  long   OPVOPU14 3591-3595
  long   OPVOSR14 3596-3600
  long   OPVPTR14 3601-3606
  long   OPVOTH14 3607-3612
  long   OPSEXP14 3613-3617
  long   OPSTCH14 3618-3623
  int    OPSSLF14 3624-3627
  long   OPSMCR14 3628-3632
  int    OPSMCD14 3633-3636
  long   OPSPRV14 3637-3641
  int    OPSVA14 3642-3645
  int    OPSTRI14 3646-3649
  byte   OPSOFD14 3650-3651
  int    OPSSTL14 3652-3654
  int    OPSWCP14 3655-3658
  int    OPSOPR14 3659-3662
  int    OPSOPU14 3663-3666
  int    OPSOSR14 3667-3670
  long   OPSPTR14 3671-3675
  int    OPSOTH14 3676-3679
  int    OPOTHV14 3680-3682
  long   OPOTCH14 3683-3689
  long   OPOEXP14 3690-3695
  int    OPOSLF14 3696-3699
  long   OPOMCR14 3700-3705
  long   OPOMCD14 3706-3711
  long   OPOPRV14 3712-3716
  long   OPOVA14 3717-3722
  int    OPOTRI14 3723-3726
  int    OPOOFD14 3727-3730
  long   OPOSTL14 3731-3735
  int    OPOWCP14 3736-3739
  int    OPOOPR14 3740-3743
  int    OPOOPU14 3744-3747
  int    OPOOSR14 3748-3751
  long   OPOPTR14 3752-3756
  long   OPOOTH14 3757-3761
  long   OPPEXP14 3762-3766
  long   OPPTCH14 3767-3772
  int    OPPSLF14 3773-3776
  long   OPPMCR14 3777-3781
  int    OPPMCD14 3782-3785
  int    OPPPRV14 3786-3789
  int    OPPVA14 3790-3793
  int    OPPTRI14 3794-3796
  byte   OPPOFD14 3797-3797
  int    OPPSTL14 3798-3800
  int    OPPWCP14 3801-3804
  long   OPPOPR14 3805-3809
  long   OPPOPU14 3810-3814
  int    OPPOSR14 3815-3818
  int    OPPPTR14 3819-3822
  long   OPPOTH14 3823-3827
  int    AMCHIR14 3828-3830
  long   AMCTCH14 3831-3835
  long   AMCEXP14 3836-3840
  long   AMCSLF14 3841-3845
  int    AMCMCR14 3846-3849
  int    AMCMCD14 3850-3853
  long   AMCPRV14 3854-3858
  int    AMCVA14 3859-3862
  int    AMCTRI14 3863-3865
  int    AMCOFD14 3866-3869
  int    AMCSTL14 3870-3873
  long   AMCWCP14 3874-3878
  long   AMCOPR14 3879-3883
  int    AMCOPU14 3884-3886
  long   AMCOSR14 3887-3891
  long   AMCPTR14 3892-3896
  long   AMCOTH14 3897-3901
  int    AMNURS14 3902-3904
  long   AMNTCH14 3905-3910
  long   AMNEXP14 3911-3916
  long   AMNSLF14 3917-3921
  long   AMNMCR14 3922-3926
  long   AMNMCD14 3927-3932
  long   AMNPRV14 3933-3937
  int    AMNVA14 3938-3941
  long   AMNTRI14 3942-3946
  int    AMNOFD14 3947-3950
  int    AMNSTL14 3951-3954
  int    AMNWCP14 3955-3958
  long   AMNOPR14 3959-3963
  int    AMNOPU14 3964-3967
  int    AMNOSR14 3968-3971
  long   AMNPTR14 3972-3976
  long   AMNOTH14 3977-3981
  byte   AMOPTO14 3982-3983
  int    AMETCH14 3984-3987
  int    AMEEXP14 3988-3991
  int    AMESLF14 3992-3995
  int    AMEMCR14 3996-3999
  int    AMEMCD14 4000-4002
  int    AMEPRV14 4003-4006
  int    AMEVA14 4007-4010
  int    AMETRI14 4011-4013
  int    AMEOFD14 4014-4016
  int    AMESTL14 4017-4020
  int    AMEWCP14 4021-4023
  int    AMEOPR14 4024-4027
  int    AMEOPU14 4028-4030
  int    AMEOSR14 4031-4033
  int    AMEPTR14 4034-4037
  int    AMEOTH14 4038-4041
  byte   AMASST14 4042-4043
  long   AMATCH14 4044-4048
  long   AMAEXP14 4049-4053
  int    AMASLF14 4054-4057
  int    AMAMCR14 4058-4061
  long   AMAMCD14 4062-4066
  int    AMAPRV14 4067-4070
  int    AMAVA14 4071-4074
  int    AMATRI14 4075-4078
  int    AMAOFD14 4079-4082
  int    AMASTL14 4083-4086
  int    AMAWCP14 4087-4089
  int    AMAOPR14 4090-4092
  int    AMAOPU14 4093-4095
  int    AMAOSR14 4096-4099
  int    AMAPTR14 4100-4103
  int    AMAOTH14 4104-4107
  int    AMTHER14 4108-4110
  long   AMTTCH14 4111-4116
  long   AMTEXP14 4117-4121
  int    AMTSLF14 4122-4125
  long   AMTMCR14 4126-4130
  long   AMTMCD14 4131-4135
  long   AMTPRV14 4136-4140
  long   AMTVA14 4141-4145
  long   AMTTRI14 4146-4150
  int    AMTOFD14 4151-4154
  int    AMTSTL14 4155-4158
  long   AMTWCP14 4159-4163
  int    AMTOPR14 4164-4167
  int    AMTOPU14 4168-4171
  int    AMTOSR14 4172-4175
  long   AMTPTR14 4176-4180
  int    AMTOTH14 4181-4184
  byte   AMTOTC14 4185-4186
  byte   AMDRC14 4187-4187
  byte   ERTOT14 4188-4189
  long   ERTTCH14 4190-4195
  long   ERTEXP14 4196-4201
  long   ERTSLF14 4202-4206
  long   ERTMCR14 4207-4211
  long   ERTMCD14 4212-4216
  long   ERTPRV14 4217-4222
  int    ERTVA14 4223-4226
  int    ERTTRI14 4227-4230
  int    ERTOFD14 4231-4234
  int    ERTSTL14 4235-4238
  int    ERTWCP14 4239-4242
  long   ERTOPR14 4243-4247
  long   ERTOPU14 4248-4252
  long   ERTOSR14 4253-4257
  long   ERTPTR14 4258-4263
  long   ERTOTH14 4264-4268
  long   ERFTCH14 4269-4274
  long   ERFEXP14 4275-4280
  long   ERFSLF14 4281-4285
  long   ERFMCR14 4286-4290
  long   ERFMCD14 4291-4295
  long   ERFPRV14 4296-4301
  int    ERFVA14 4302-4305
  int    ERFTRI14 4306-4309
  int    ERFOFD14 4310-4313
  int    ERFSTL14 4314-4317
  int    ERFWCP14 4318-4321
  long   ERFOPR14 4322-4326
  long   ERFOPU14 4327-4331
  long   ERFOSR14 4332-4336
  long   ERFPTR14 4337-4342
  long   ERFOTH14 4343-4347
  long   ERDEXP14 4348-4352
  long   ERDTCH14 4353-4357
  int    ERDSLF14 4358-4361
  long   ERDMCR14 4362-4366
  long   ERDMCD14 4367-4371
  long   ERDPRV14 4372-4376
  int    ERDVA14 4377-4380
  int    ERDTRI14 4381-4383
  byte   ERDOFD14 4384-4384
  int    ERDSTL14 4385-4387
  int    ERDWCP14 4388-4391
  int    ERDOPR14 4392-4395
  int    ERDOPU14 4396-4398
  int    ERDOSR14 4399-4402
  long   ERDPTR14 4403-4407
  int    ERDOTH14 4408-4411
  byte   IPZERO14 4412-4412
  long   ZIFTCH14 4413-4417
  long   ZIFEXP14 4418-4422
  int    ZIFSLF14 4423-4426
  long   ZIFMCR14 4427-4431
  int    ZIFMCD14 4432-4435
  long   ZIFPRV14 4436-4440
  int    ZIFVA14 4441-4443
  int    ZIFTRI14 4444-4446
  byte   ZIFOFD14 4447-4447
  byte   ZIFSTL14 4448-4448
  long   ZIFWCP14 4449-4453
  int    ZIFOPR14 4454-4457
  byte   ZIFOPU14 4458-4458
  byte   ZIFOSR14 4459-4459
  long   ZIFPTR14 4460-4464
  int    ZIFOTH14 4465-4468
  int    ZIDEXP14 4469-4472
  long   ZIDTCH14 4473-4477
  int    ZIDSLF14 4478-4481
  int    ZIDMCR14 4482-4485
  int    ZIDMCD14 4486-4488
  int    ZIDPRV14 4489-4492
  byte   ZIDVA14 4493-4494
  int    ZIDTRI14 4495-4497
  byte   ZIDOFD14 4498-4498
  byte   ZIDSTL14 4499-4499
  int    ZIDWCP14 4500-4503
  int    ZIDOPR14 4504-4506
  byte   ZIDOPU14 4507-4507
  byte   ZIDOSR14 4508-4508
  int    ZIDPTR14 4509-4512
  int    ZIDOTH14 4513-4515
  byte   IPDIS14 4516-4517
  long   IPTEXP14 4518-4523
  long   IPTTCH14 4524-4530
  long   IPTSLF14 4531-4535
  long   IPTMCR14 4536-4541
  long   IPTMCD14 4542-4547
  long   IPTPRV14 4548-4553
  long   IPTVA14 4554-4558
  long   IPTTRI14 4559-4563
  long   IPTOFD14 4564-4568
  long   IPTSTL14 4569-4573
  long   IPTWCP14 4574-4578
  long   IPTOPR14 4579-4584
  long   IPTOPU14 4585-4590
  long   IPTOSR14 4591-4596
  long   IPTPTR14 4597-4602
  long   IPTOTH14 4603-4608
  long   IPFEXP14 4609-4614
  long   IPFTCH14 4615-4621
  long   IPFSLF14 4622-4626
  long   IPFMCR14 4627-4632
  long   IPFMCD14 4633-4638
  long   IPFPRV14 4639-4644
  long   IPFVA14 4645-4649
  long   IPFTRI14 4650-4654
  long   IPFOFD14 4655-4659
  long   IPFSTL14 4660-4664
  long   IPFWCP14 4665-4669
  long   IPFOPR14 4670-4675
  long   IPFOPU14 4676-4681
  long   IPFOSR14 4682-4687
  long   IPFPTR14 4688-4693
  long   IPFOTH14 4694-4699
  long   IPDEXP14 4700-4704
  long   IPDTCH14 4705-4710
  int    IPDSLF14 4711-4714
  long   IPDMCR14 4715-4719
  long   IPDMCD14 4720-4724
  long   IPDPRV14 4725-4729
  int    IPDVA14 4730-4733
  int    IPDTRI14 4734-4737
  byte   IPDOFD14 4738-4739
  int    IPDSTL14 4740-4743
  int    IPDWCP14 4744-4747
  long   IPDOPR14 4748-4752
  int    IPDOPU14 4753-4756
  long   IPDOSR14 4757-4761
  long   IPDPTR14 4762-4766
  long   IPDOTH14 4767-4771
  int    IPNGTD14 4772-4774
  byte   DVTOT14 4775-4776
  long   DVTTCH14 4777-4781
  long   DVTEXP14 4782-4786
  long   DVTSLF14 4787-4791
  long   DVTMCR14 4792-4796
  long   DVTMCD14 4797-4801
  long   DVTPRV14 4802-4806
  int    DVTVA14 4807-4810
  int    DVTTRI14 4811-4814
  int    DVTOFD14 4815-4818
  int    DVTSTL14 4819-4822
  int    DVTWCP14 4823-4826
  int    DVTOPR14 4827-4830
  int    DVTOPU14 4831-4834
  int    DVTOSR14 4835-4838
  long   DVTPTR14 4839-4843
  int    DVTOTH14 4844-4847
  byte   DVGEN14 4848-4849
  long   DVGTCH14 4850-4854
  long   DVGEXP14 4855-4859
  long   DVGSLF14 4860-4864
  int    DVGMCR14 4865-4868
  int    DVGMCD14 4869-4872
  long   DVGPRV14 4873-4877
  int    DVGVA14 4878-4881
  int    DVGTRI14 4882-4885
  int    DVGOFD14 4886-4889
  int    DVGSTL14 4890-4893
  int    DVGWCP14 4894-4897
  int    DVGOPR14 4898-4901
  int    DVGOPU14 4902-4905
  int    DVGOSR14 4906-4909
  long   DVGPTR14 4910-4914
  int    DVGOTH14 4915-4918
  byte   DVORTH14 4919-4920
  long   DVOTCH14 4921-4925
  long   DVOEXP14 4926-4930
  long   DVOSLF14 4931-4935
  int    DVOMCR14 4936-4939
  long   DVOMCD14 4940-4944
  long   DVOPRV14 4945-4949
  int    DVOVA14 4950-4952
  int    DVOTRI14 4953-4956
  byte   DVOOFD14 4957-4957
  int    DVOSTL14 4958-4961
  byte   DVOWCP14 4962-4962
  int    DVOOPR14 4963-4966
  byte   DVOOPU14 4967-4967
  int    DVOOSR14 4968-4970
  long   DVOPTR14 4971-4975
  int    DVOOTH14 4976-4979
  int    HHTOTD14 4980-4982
  int    HHAGD14 4983-4985
  long   HHATCH14 4986-4991
  long   HHAEXP14 4992-4997
  long   HHASLF14 4998-5002
  long   HHAMCR14 5003-5007
  long   HHAMCD14 5008-5013
  long   HHAPRV14 5014-5019
  long   HHAVA14 5020-5024
  int    HHATRI14 5025-5027
  int    HHAOFD14 5028-5031
  long   HHASTL14 5032-5036
  long   HHAWCP14 5037-5041
  long   HHAOPR14 5042-5046
  byte   HHAOPU14 5047-5047
  long   HHAOSR14 5048-5052
  long   HHAPTR14 5053-5058
  long   HHAOTH14 5059-5063
  int    HHINDD14 5064-5066
  long   HHNTCH14 5067-5071
  long   HHNEXP14 5072-5076
  long   HHNSLF14 5077-5081
  long   HHNMCD14 5082-5086
  int    HHNMCR14 5087-5089
  int    HHNPRV14 5090-5092
  int    HHNVA14 5093-5095
  byte   HHNTRI14 5096-5096
  byte   HHNOFD14 5097-5097
  int    HHNSTL14 5098-5100
  int    HHNWCP14 5101-5103
  byte   HHNOPR14 5104-5104
  byte   HHNOPU14 5105-5105
  int    HHNOSR14 5106-5108
  int    HHNPTR14 5109-5111
  int    HHNOTH14 5112-5114
  int    HHINFD14 5115-5117
  long   VISEXP14 5118-5122
  long   VISTCH14 5123-5127
  int    VISSLF14 5128-5131
  int    VISMCR14 5132-5135
  int    VISMCD14 5136-5139
  int    VISPRV14 5140-5143
  int    VISVA14 5144-5146
  int    VISTRI14 5147-5150
  int    VISOFD14 5151-5154
  long   VISSTL14 5155-5159
  byte   VISWCP14 5160-5161
  int    VISOPR14 5162-5165
  int    VISOPU14 5166-5168
  int    VISOSR14 5169-5171
  int    VISPTR14 5172-5175
  long   VISOTH14 5176-5180
  long   OTHTCH14 5181-5186
  long   OTHEXP14 5187-5192
  long   OTHSLF14 5193-5197
  long   OTHMCR14 5198-5202
  long   OTHMCD14 5203-5207
  long   OTHPRV14 5208-5212
  int    OTHVA14 5213-5216
  int    OTHTRI14 5217-5219
  int    OTHOFD14 5220-5222
  long   OTHSTL14 5223-5227
  int    OTHWCP14 5228-5230
  int    OTHOPR14 5231-5234
  int    OTHOPU14 5235-5238
  int    OTHOSR14 5239-5242
  long   OTHPTR14 5243-5247
  long   OTHOTH14 5248-5252
  int    RXTOT14 5253-5255
  long   RXEXP14 5256-5261
  long   RXSLF14 5262-5266
  long   RXMCR14 5267-5272
  long   RXMCD14 5273-5277
  long   RXPRV14 5278-5283
  long   RXVA14 5284-5288
  long   RXTRI14 5289-5293
  int    RXOFD14 5294-5297
  long   RXSTL14 5298-5302
  long   RXWCP14 5303-5307
  long   RXOPR14 5308-5312
  long   RXOPU14 5313-5317
  int    RXOSR14 5318-5321
  long   RXPTR14 5322-5327
  long   RXOTH14 5328-5332
  double PERWT14F 5333-5344
  double FAMWT14F 5345-5356
  double FAMWT14C 5357-5368
  double SAQWT14F 5369-5381
  double DIABW14F 5382-5393
  int    VARSTR 5394-5397
  byte   VARPSU 5398-5398
using H171.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID14 "FAMILY ID (STUDENT MERGED IN) - 12/31/14";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR14 "RU LETTER AS OF 12/31/14";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE14 "RU SIZE AS OF 12/31/14";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS14 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/14";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE14 "RU SIZE INCLUDING STUDENT AS OF 12/31/14";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION14 "CENSUS REGION AS OF 12/31/14";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS14 "REFERENCE PERSON AS OF 12/31/14";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP14 "1ST RESPONDENT INDICATOR AS OF 12/31/14";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY14 "WAS RESPONDENT A PROXY AS OF 12/31/14";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFM14 "2014 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY14 "2014 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP14 "INSCOPE - R5/3 START THROUGH 12/31/14";
label variable INSC1231 "INSCOPE STATUS ON 12/31/14";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2014";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND14 "ELIGIBILITY STATUS AS OF 12/31/14";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE14X "AGE AS OF 12/31/14 (EDITED/IMPUTED)";
label variable AGELAST "PERSON S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEV1X "RACE (EDITED/IMPUTED)";
label variable RACEV2X "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPNCAT "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY14X "MARITAL STATUS-12/31/14 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID14 "SPOUSE ID - 12/31/14";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN14 "MARITAL STATUS W/SPOUSE PRESENT-12/31/14";
label variable EDUYRDG "YEAR OF EDUCATION OR HIGHEST DEGREE";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable EDRECODE "EDUCATION RECODE (EDITED)";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU14X "STUDENT STATUS IF AGES 17-23 - 12/31/14";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable REFRL31X "RELATION TO REF PERS- R3/1 (EDIT/IMP)";
label variable REFRL42X "RELATION TO REF PERS- R4/2 (EDIT/IMP)";
label variable REFRL53X "RELATION TO REF PERS- R5/3 (EDIT/IMP)";
label variable REFRL14X "RELATION TO REF PERS-12/31/14 (EDIT/IMP)";
label variable OTHLANG "IN FAMILY WITH SOMEONE SPKNG OTHER LANG";
label variable LANGSPK "LANGUAGE SPOKEN AT HOME OTHER THAN ENGL";
label variable HWELLSPE "HOW WELL PERSON SPEAKS ENGLISH";
label variable BORNUSA "PERSON BORN IN THE US";
label variable YRSINUS "YEARS PERSON LIVED IN THE US";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHBRON53 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R5/3";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable CACERVIX "CANCER DIAGNOSED - CERVIX (>17)";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (>17)";
label variable CAMELANO "CANCER DIAGNOSED - MELANOMA (>17)";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable CASKINDK "CANCER DIAGNOSED-SKIN-UNKNOWN TYPE (>17)";
label variable CAUTERUS "CANCER DIAGNOSED - UTERUS (>17)";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASTHEP53 "WHEN WAS LAST EPISODE OF ASTHMA - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable ADHDADDX "ADHDADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable PREGNT31 "PREGNANT DURING REF PERIOD - RD 3/1";
label variable PREGNT42 "PREGNANT DURING REF PERIOD - RD 4/2";
label variable PREGNT53 "PREGNANT DURING REF PERIOD - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable DFHEAR42 "SERIOUS DIFFICULTY HEARING-RD 4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable DFSEE42 "SERIOUS DIFFICULTY SEE W/GLASSES-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable DFCOG42 "SERIOUS COGNITIVE DIFFICULTIES-RD 4/2";
label variable DFWLKC42 "SERIOUS DIFCULTY WLK/CLIMB STAIRS-RD 4/2";
label variable DFDRSB42 "DIFFICULTY DRESSING/BATHING-RD 4/2";
label variable DFERND42 "DIFFICULTY DOING ERRANDS ALONE-RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable ANYLMT14 "ANY LIMITATION IN P18R3,4,5/P19R1,2,3";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHENEC42 "CAHPS:12MOS:EASY GET NEC CARE (0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHEYRE42 "CAHPS:12MOS:ESY W/RFR TO SPEC(0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU VACINATION (>17)-RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable BSTST53 "MST RCNT BLD STOOL TST HME KIT(>39)-R5/3";
label variable BSTSRE53 "RSN HAVE BLD STOOL TST (>39)-R5/3";
label variable CLNTST53 "MOST RECENT COLONOSCOPY (>39) - R5/3";
label variable CLNTRE53 "RSN HAVE COLONOSCOPY (>39)-R5/3";
label variable SGMTST53 "MOST RECENT SIGMOIDOSCOPY (>39) - R5/3";
label variable SGMTRE53 "RSN HAVE SIGMOIDOSCOPY (>39)-R5/3";
label variable PHYEXE53 "MOD/VIG PHYS EXEC 5X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADEGMC42 "SAQ 12MOS: EASY GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADINST42 "SAQ 12 MOS: DR GAVE SPCIFC INSTRCTNS";
label variable ADEZUN42 "SAQ 12 MOS: DR GIVEN INSTR. EZ UNDRSTD";
label variable ADTLHW42 "SAQ 12 MOS: DR ASKED R DESC HOW FOLLOW";
label variable ADFFRM42 "SAQ 12 MOS: HAD TO FILL OUT/SIGN FORMS";
label variable ADFHLP42 "SAQ 12 MOS: OFFRD HELP FILLING OUT FORMS";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADESSP42 "SAQ 12MOS: HOW ESY TO SEE SPECIALIST";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C IN 2013";
label variable DSFT1553 "DCS: HAD FEET CHECKED DURING 2015";
label variable DSFT1453 "DCS: HAD FEET CHECKED DURING 2014";
label variable DSFT1353 "DCS: HAD FEET CHECKED DURING 2013";
label variable DSFB1353 "DCS: HAD FEET CHECKED BEFORE 2013";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY1553 "DCS: DILATED EYE EXAM IN 2015";
label variable DSEY1453 "DCS: DILATED EYE EXAM IN 2014";
label variable DSEY1353 "DCS: DILATED EYE EXAM IN 2013";
label variable DSEB1353 "DCS: DILATED EYE EXAM BEFORE 2013";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH1553 "DCS: BLOOD CHOLESTEROL CHECKED IN 2015";
label variable DSCH1453 "DCS: BLOOD CHOLESTEROL CHECKED IN 2014";
label variable DSCH1353 "DCS: BLOOD CHOLESTEROL CHECKED IN 2013";
label variable DSCB1353 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2013";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL1553 "DCS: GOT FLU VACCINATION IN 2015";
label variable DSFL1453 "DCS: GOT FLU VACCINATION IN 2014";
label variable DSFL1353 "DCS: GOT FLU VACCINATION IN 2013";
label variable DSVB1353 "DCS: GOT FLU VACCINATION BEFORE 2013";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable NOHINS42 "AC08 OTH REAS NO USC:NO HLTH INSRNC-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable PRVSPK42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/14";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable EMPST31H "EMPLOYMENT STATUS RD 3/1 (IMP)";
label variable EMPST42H "EMPLOYMENT STATUS RD 4/2 (IMP)";
label variable EMPST53H "EMPLOYMENT STATUS RD 5/3 (IMP)";
label variable SLFCM31H "SELF-EMPLOYED AT RD 3/1 CMJ (IMP)";
label variable SLFCM42H "SELF-EMPLOYED AT RD 4/2 CMJ (IMP)";
label variable SLFCM53H "SELF-EMPLOYED AT RD 5/3 CMJ (IMP)";
label variable NMEMP31H "NUMBER OF EMPLOYEES AT RD 3/1 CMJ (IMP)";
label variable NMEMP42H "NUMBER OF EMPLOYEES AT RD 4/2 CMJ (IMP)";
label variable NMEMP53H "NUMBER OF EMPLOYEES AT RD 5/3 CMJ (IMP)";
label variable MORE31H "RD 3/1 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable MORE42H "RD 4/2 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable MORE53H "RD 5/3 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable INDCT31H "INDUSTRY GROUP RD 3/1 CMJ (IMP)";
label variable INDCT42H "INDUSTRY GROUP RD 4/2 CMJ (IMP)";
label variable INDCT53H "INDUSTRY GROUP RD 5/3 CMJ (IMP)";
label variable OCCCT31H "OCCUPATION GROUP RD 3/1 CMJ (IMP)";
label variable OCCCT42H "OCCUPATION GROUP RD 4/2 CMJ (IMP)";
label variable OCCCT53H "OCCUPATION GROUP RD 5/3 CMJ (IMP)";
label variable HOUR31H "HOURS PER WEEK AT RD 3/1 CMJ (IMP)";
label variable HOUR42H "HOURS PER WEEK AT RD 4/2 CMJ (IMP)";
label variable HOUR53H "HOURS PER WEEK AT RD 5/3 CMJ (IMP)";
label variable JBORG31H "PRV, ST-LC GOV, FED GOV RD 3/1 CMJ (IMP)";
label variable JBORG42H "PRV, ST-LC GOV, FED GOV RD 4/2 CMJ (IMP)";
label variable JBORG53H "PRV, ST-LC GOV, FED GOV RD 5/3 CMJ (IMP)";
label variable UNION31H "UNION STATUS AT RD 3/1 CMJ (IMP)";
label variable UNION42H "UNION STATUS AT RD 4/2 CMJ (IMP)";
label variable UNION53H "UNION STATUS AT RD 5/3 CMJ (IMP)";
label variable BSNTY31H "SOL PROP, PRTNR, CORP, RD 3/1 CMJ (IMP)";
label variable BSNTY42H "SOL PROP, PRTNR, CORP, RD 4/2 CMJ (IMP)";
label variable BSNTY53H "SOL PROP, PRTNR, CORP, RD 5/3 CMJ (IMP)";
label variable HRWG31H "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42H "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53H "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable CMJHLD31 "HLTH INSUR HELD FROM RD 3/1 CMJ (PRPL)";
label variable CMJHLD42 "HLTH INSUR HELD FROM RD 4/2 CMJ (PRPL)";
label variable CMJHLD53 "HLTH INSUR HELD FROM RD 5/3 CMJ (PRPL)";
label variable OFFER31H "HEALTH INSUR OFFERED BY RD 3/1 CMJ (IMP)";
label variable OFFER42H "HEALTH INSUR OFFERED BY RD 4/2 CMJ (IMP)";
label variable OFFER53H "HEALTH INSUR OFFERED BY RD 5/3 CMJ (IMP)";
label variable OFEMP31H "EMP OFFERS HEALTH INS RD 3/1 CMJ (IMP)";
label variable OFEMP42H "EMP OFFERS HEALTH INS RD 4/2 CMJ (IMP)";
label variable OFEMP53H "EMP OFFERS HEALTH INS RD 5/3 CMJ (IMP)";
label variable PYVAC31H "PAID VACATION AT RD 3/1 CMJ (IMP)";
label variable PYVAC42H "PAID VACATION AT RD 4/2 CMJ (IMP)";
label variable PYVAC53H "PAID VACATION AT RD 5/3 CMJ (IMP)";
label variable SCPAY31H "PAID SICK LEAVE AT RD 3/1 CMJ (IMP)";
label variable SCPAY42H "PAID SICK LEAVE AT RD 4/2 CMJ (IMP)";
label variable SCPAY53H "PAID SICK LEAVE AT RD 5/3 CMJ (IMP)";
label variable PAYDR31H "PAID LEAVE TO VISIT DR RD 3/1 CMJ (IMP)";
label variable PAYDR42H "PAID LEAVE TO VISIT DR RD 4/2 CMJ (IMP)";
label variable PAYDR53H "PAID LEAVE TO VISIT DR RD 5/3 CMJ (IMP)";
label variable RTPLN31H "PENSION PLAN AT RD 3/1 CMJ (IMP)";
label variable RTPLN42H "PENSION PLAN AT RD 4/2 CMJ (IMP)";
label variable RTPLN53H "PENSION PLAN AT RD 5/3 CMJ (IMP)";
label variable AFDC14 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR14 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL14 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT14 "PERSON S FILING STATUS";
label variable FILER14 "PRIMARY OR SECONDARY FILER";
label variable JTINRU14 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID14 "PID OF SECONDARY FILER";
label variable CLMDEP14 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT14 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU14 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD14 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM14 "TAX FORM PERSON WILL FILE";
label variable CLMHIP14 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT14 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST14 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN14 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL14 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP14X "PERSON S TOTAL INCOME";
label variable FAMINC14 "FAMILY S TOTAL INCOME";
label variable POVCAT14 "FAMILY INC AS % OF POVERTY LINE - CATEGO";
label variable POVLEV14 "FAMILY INC AS % OF POVERTY LINE - CONTIN";
label variable WAGEP14X "PERSON S WAGE INCOME";
label variable WAGIMP14 "WAGE IMPUTATION FLAG";
label variable BUSNP14X "PERSON S BUSINESS INCOME";
label variable BUSIMP14 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP14X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP14 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP14X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP14 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP14X "PERSON S INTEREST INCOME";
label variable INTIMP14 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP14X "PERSON S DIVIDEND INCOME";
label variable DIVIMP14 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP14X "PERSON S SALES INCOME";
label variable SALIMP14 "SALES INCOME IMPUTATION FLAG";
label variable PENSP14X "PERSON S PENSION INCOME";
label variable PENIMP14 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP14X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP14 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP14X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP14 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP14X "PERSON S VETERAN S INCOME";
label variable VETIMP14 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP14X "PERSON S IRA INCOME";
label variable IRAIMP14 "IRA INCOME IMPUTATION FLAG";
label variable ALIMP14X "PERSON S ALIMONY INCOME";
label variable ALIIMP14 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP14X "PERSON S CHILD SUPPORT";
label variable CHLIMP14 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP14X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP14 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP14X "PERSON S SSI";
label variable SSIIMP14 "SSI IMPUTATION FLAG";
label variable PUBP14X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP14 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP14X "PERSON S OTHER INCOME";
label variable OTHIMP14 "OTHER INCOME IMPUTATION FLAG";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable TRIJA14X "COVERED BY TRICARE/CHAMPVA IN JAN14 (ED)";
label variable TRIFE14X "COVERED BY TRICARE/CHAMPVA IN FEB14 (ED)";
label variable TRIMA14X "COVERED BY TRICARE/CHAMPVA IN MAR14 (ED)";
label variable TRIAP14X "COVERED BY TRICARE/CHAMPVA IN APR14(ED)";
label variable TRIMY14X "COVERED BY TRICARE/CHAMPVA IN MAY14 (ED)";
label variable TRIJU14X "COVERED BY TRICARE/CHAMPVA IN JUN14 (ED)";
label variable TRIJL14X "COVERED BY TRICARE/CHAMPVA IN JUL14 (ED)";
label variable TRIAU14X "COVERED BY TRICARE/CHAMPVA IN AUG14 (ED)";
label variable TRISE14X "COVERED BY TRICARE/CHAMPVA IN SEP14 (ED)";
label variable TRIOC14X "COVERED BY TRICARE/CHAMPVA IN OCT14 (ED)";
label variable TRINO14X "COVERED BY TRICARE/CHAMPVA IN NOV14 (ED)";
label variable TRIDE14X "COVERED BY TRICARE/CHAMPVA IN DEC14 (ED)";
label variable MCRJA14 "COVERED BY MEDICARE IN JAN14";
label variable MCRFE14 "COVERED BY MEDICARE IN FEB14";
label variable MCRMA14 "COVERED BY MEDICARE IN MAR14";
label variable MCRAP14 "COVERED BY MEDICARE IN APR14";
label variable MCRMY14 "COVERED BY MEDICARE IN MAY14";
label variable MCRJU14 "COVERED BY MEDICARE IN JUN14";
label variable MCRJL14 "COVERED BY MEDICARE IN JUL14";
label variable MCRAU14 "COVERED BY MEDICARE IN AUG14";
label variable MCRSE14 "COVERED BY MEDICARE IN SEP14";
label variable MCROC14 "COVERED BY MEDICARE IN OCT14";
label variable MCRNO14 "COVERED BY MEDICARE IN NOV14";
label variable MCRDE14 "COVERED BY MEDICARE IN DEC14";
label variable MCRJA14X "COVERED BY MEDICARE IN JAN14 (ED)";
label variable MCRFE14X "COVERED BY MEDICARE IN FEB14 (ED)";
label variable MCRMA14X "COVERED BY MEDICARE IN MAR14 (ED)";
label variable MCRAP14X "COVERED BY MEDICARE IN APR14 (ED)";
label variable MCRMY14X "COVERED BY MEDICARE IN MAY14 (ED)";
label variable MCRJU14X "COVERED BY MEDICARE IN JUN14 (ED)";
label variable MCRJL14X "COVERED BY MEDICARE IN JUL14 (ED)";
label variable MCRAU14X "COVERED BY MEDICARE IN AUG14 (ED)";
label variable MCRSE14X "COVERED BY MEDICARE IN SEP14 (ED)";
label variable MCROC14X "COVERED BY MEDICARE IN OCT14 (ED)";
label variable MCRNO14X "COVERED BY MEDICARE IN NOV14 (ED)";
label variable MCRDE14X "COVERED BY MEDICARE IN DEC14 (ED)";
label variable MCDJA14 "COV BY MEDICAID OR SCHIP IN JAN14";
label variable MCDFE14 "COV BY MEDICAID OR SCHIP IN FEB14";
label variable MCDMA14 "COV BY MEDICAID OR SCHIP IN MAR14";
label variable MCDAP14 "COV BY MEDICAID OR SCHIP IN APR14";
label variable MCDMY14 "COV BY MEDICAID OR SCHIP IN MAY14";
label variable MCDJU14 "COV BY MEDICAID OR SCHIP IN JUN14";
label variable MCDJL14 "COV BY MEDICAID OR SCHIP IN JUL14";
label variable MCDAU14 "COV BY MEDICAID OR SCHIP IN AUG14";
label variable MCDSE14 "COV BY MEDICAID OR SCHIP IN SEP14";
label variable MCDOC14 "COV BY MEDICAID OR SCHIP IN OCT14";
label variable MCDNO14 "COV BY MEDICAID OR SCHIP IN NOV14";
label variable MCDDE14 "COV BY MEDICAID OR SCHIP IN DEC14";
label variable MCDJA14X "COV BY MEDICAID OR SCHIP IN JAN14 (ED)";
label variable MCDFE14X "COV BY MEDICAID OR SCHIP IN FEB14 (ED)";
label variable MCDMA14X "COV BY MEDICAID OR SCHIP IN MAR14 (ED)";
label variable MCDAP14X "COV BY MEDICAID OR SCHIP IN APR14 (ED)";
label variable MCDMY14X "COV BY MEDICAID OR SCHIP IN MAY14 (ED)";
label variable MCDJU14X "COV BY MEDICAID OR SCHIP IN JUN14 (ED)";
label variable MCDJL14X "COV BY MEDICAID OR SCHIP IN JUL14 (ED)";
label variable MCDAU14X "COV BY MEDICAID OR SCHIP IN AUG14 (ED)";
label variable MCDSE14X "COV BY MEDICAID OR SCHIP IN SEP14 (ED)";
label variable MCDOC14X "COV BY MEDICAID OR SCHIP IN OCT14 (ED)";
label variable MCDNO14X "COV BY MEDICAID OR SCHIP IN NOV14 (ED)";
label variable MCDDE14X "COV BY MEDICAID OR SCHIP IN DEC14 (ED)";
label variable OPAJA14 "COV BY OTHER PUBLIC A INS IN JAN14";
label variable OPAFE14 "COV BY OTHER PUBLIC A INS IN FEB14";
label variable OPAMA14 "COV BY OTHER PUBLIC A INS IN MAR14";
label variable OPAAP14 "COV BY OTHER PUBLIC A INS IN APR14";
label variable OPAMY14 "COV BY OTHER PUBLIC A INS IN MAY14";
label variable OPAJU14 "COV BY OTHER PUBLIC A INS IN JUN14";
label variable OPAJL14 "COV BY OTHER PUBLIC A INS IN JUL14";
label variable OPAAU14 "COV BY OTHER PUBLIC A INS IN AUG14";
label variable OPASE14 "COV BY OTHER PUBLIC A INS IN SEP14";
label variable OPAOC14 "COV BY OTHER PUBLIC A INS IN OCT14";
label variable OPANO14 "COV BY OTHER PUBLIC A INS IN NOV14";
label variable OPADE14 "COV BY OTHER PUBLIC A INS IN DEC14";
label variable OPBJA14 "COV BY OTHER PUBLIC B INS IN JAN14";
label variable OPBFE14 "COV BY OTHER PUBLIC B INS IN FEB14";
label variable OPBMA14 "COV BY OTHER PUBLIC B INS IN MAR14";
label variable OPBAP14 "COV BY OTHER PUBLIC B INS IN APR14";
label variable OPBMY14 "COV BY OTHER PUBLIC B INS IN MAY14";
label variable OPBJU14 "COV BY OTHER PUBLIC B INS IN JUN14";
label variable OPBJL14 "COV BY OTHER PUBLIC B INS IN JUL14";
label variable OPBAU14 "COV BY OTHER PUBLIC B INS IN AUG14";
label variable OPBSE14 "COV BY OTHER PUBLIC B INS IN SEP14";
label variable OPBOC14 "COV BY OTHER PUBLIC B INS IN OCT14";
label variable OPBNO14 "COV BY OTHER PUBLIC B INS IN NOV14";
label variable OPBDE14 "COV BY OTHER PUBLIC B INS IN DEC14";
label variable STAJA14 "COVERED BY OTHER STATE PROG IN JAN14";
label variable STAFE14 "COVERED BY OTHER STATE PROG IN FEB14";
label variable STAMA14 "COVERED BY OTHER STATE PROG IN MAR14";
label variable STAAP14 "COVERED BY OTHER STATE PROG IN APR14";
label variable STAMY14 "COVERED BY OTHER STATE PROG IN MAY14";
label variable STAJU14 "COVERED BY OTHER STATE PROG IN JUN14";
label variable STAJL14 "COVERED BY OTHER STATE PROG IN JUL14";
label variable STAAU14 "COVERED BY OTHER STATE PROG IN AUG14";
label variable STASE14 "COVERED BY OTHER STATE PROG IN SEP14";
label variable STAOC14 "COVERED BY OTHER STATE PROG IN OCT14";
label variable STANO14 "COVERED BY OTHER STATE PROG IN NOV14";
label variable STADE14 "COVERED BY OTHER STATE PROG IN DEC14";
label variable PUBJA14X "COVR BY ANY PUBLIC INS IN JAN14 (ED)";
label variable PUBFE14X "COVR BY ANY PUBLIC INS IN FEB14 (ED)";
label variable PUBMA14X "COVR BY ANY PUBLIC INS IN MAR14 (ED)";
label variable PUBAP14X "COVR BY ANY PUBLIC INS IN APR14 (ED)";
label variable PUBMY14X "COVR BY ANY PUBLIC INS IN MAY14 (ED)";
label variable PUBJU14X "COVR BY ANY PUBLIC INS IN JUN14 (ED)";
label variable PUBJL14X "COVR BY ANY PUBLIC INS IN JUL14 (ED)";
label variable PUBAU14X "COVR BY ANY PUBLIC INS IN AUG14 (ED)";
label variable PUBSE14X "COVR BY ANY PUBLIC INS IN SEP14 (ED)";
label variable PUBOC14X "COVR BY ANY PUBLIC INS IN OCT14 (ED)";
label variable PUBNO14X "COVR BY ANY PUBLIC INS IN NOV14 (ED)";
label variable PUBDE14X "COVR BY ANY PUBLIC INS IN DEC14 (ED)";
label variable PEGJA14 "COVERED BY EMPL UNION INS IN JAN14";
label variable PEGFE14 "COVERED BY EMPL UNION INS IN FEB14";
label variable PEGMA14 "COVERED BY EMPL UNION INS IN MAR14";
label variable PEGAP14 "COVERED BY EMPL UNION INS IN APR14";
label variable PEGMY14 "COVERED BY EMPL UNION INS IN MAY14";
label variable PEGJU14 "COVERED BY EMPL UNION INS IN JUN14";
label variable PEGJL14 "COVERED BY EMPL UNION INS IN JUL14";
label variable PEGAU14 "COVERED BY EMPL UNION INS IN AUG14";
label variable PEGSE14 "COVERED BY EMPL UNION INS IN SEP14";
label variable PEGOC14 "COVERED BY EMPL UNION INS IN OCT14";
label variable PEGNO14 "COVERED BY EMPL UNION INS IN NOV14";
label variable PEGDE14 "COVERED BY EMPL UNION INS IN DEC14";
label variable PDKJA14 "COVR BY PRIV INS (SOURCE UNKNWN) JAN14";
label variable PDKFE14 "COVR BY PRIV INS (SOURCE UNKNWN) FEB14";
label variable PDKMA14 "COVR BY PRIV INS (SOURCE UNKNWN) MAR14";
label variable PDKAP14 "COVR BY PRIV INS (SOURCE UNKNWN) APR14";
label variable PDKMY14 "COVR BY PRIV INS (SOURCE UNKNWN) MAY14";
label variable PDKJU14 "COVR BY PRIV INS (SOURCE UNKNWN) JUN14";
label variable PDKJL14 "COVR BY PRIV INS (SOURCE UNKNWN) JUL14";
label variable PDKAU14 "COVR BY PRIV INS (SOURCE UNKNWN) AUG14";
label variable PDKSE14 "COVR BY PRIV INS (SOURCE UNKNWN) SEP14";
label variable PDKOC14 "COVR BY PRIV INS (SOURCE UNKNWN) OCT14";
label variable PDKNO14 "COVR BY PRIV INS (SOURCE UNKNWN) NOV14";
label variable PDKDE14 "COVR BY PRIV INS (SOURCE UNKNWN) DEC14";
label variable PNGJA14 "COVERED BY NONGROUP INS IN JAN14";
label variable PNGFE14 "COVERED BY NONGROUP INS IN FEB14";
label variable PNGMA14 "COVERED BY NONGROUP INS IN MAR14";
label variable PNGAP14 "COVERED BY NONGROUP INS IN APR14";
label variable PNGMY14 "COVERED BY NONGROUP INS IN MAY14";
label variable PNGJU14 "COVERED BY NONGROUP INS IN JUN14";
label variable PNGJL14 "COVERED BY NONGROUP INS IN JUL14";
label variable PNGAU14 "COVERED BY NONGROUP INS IN AUG14";
label variable PNGSE14 "COVERED BY NONGROUP INS IN SEP14";
label variable PNGOC14 "COVERED BY NONGROUP INS IN OCT14";
label variable PNGNO14 "COVERED BY NONGROUP INS IN NOV14";
label variable PNGDE14 "COVERED BY NONGROUP INS IN DEC14";
label variable POGJA14 "COVERED BY OTHER GROUP INS IN JAN14";
label variable POGFE14 "COVERED BY OTHER GROUP INS IN FEB14";
label variable POGMA14 "COVERED BY OTHER GROUP INS IN MAR14";
label variable POGAP14 "COVERED BY OTHER GROUP INS IN APR14";
label variable POGMY14 "COVERED BY OTHER GROUP INS IN MAY14";
label variable POGJU14 "COVERED BY OTHER GROUP INS IN JUN14";
label variable POGJL14 "COVERED BY OTHER GROUP INS IN JUL14";
label variable POGAU14 "COVERED BY OTHER GROUP INS IN AUG14";
label variable POGSE14 "COVERED BY OTHER GROUP INS IN SEP14";
label variable POGOC14 "COVERED BY OTHER GROUP INS IN OCT14";
label variable POGNO14 "COVERED BY OTHER GROUP INS IN NOV14";
label variable POGDE14 "COVERED BY OTHER GROUP INS IN DEC14";
label variable PRSJA14 "COVERED BY SELF-EMP-1 INS IN JAN14";
label variable PRSFE14 "COVERED BY SELF-EMP-1 INS IN FEB14";
label variable PRSMA14 "COVERED BY SELF-EMP-1 INS IN MAR14";
label variable PRSAP14 "COVERED BY SELF-EMP-1 INS IN APR14";
label variable PRSMY14 "COVERED BY SELF-EMP-1 INS IN MAY14";
label variable PRSJU14 "COVERED BY SELF-EMP-1 INS IN JUN14";
label variable PRSJL14 "COVERED BY SELF-EMP-1 INS IN JUL14";
label variable PRSAU14 "COVERED BY SELF-EMP-1 INS IN AUG14";
label variable PRSSE14 "COVERED BY SELF-EMP-1 INS IN SEP14";
label variable PRSOC14 "COVERED BY SELF-EMP-1 INS IN OCT14";
label variable PRSNO14 "COVERED BY SELF-EMP-1 INS IN NOV14";
label variable PRSDE14 "COVERED BY SELF-EMP-1 INS IN DEC14";
label variable POUJA14 "COVERED BY HOLDER OUTSIDE OF RU IN JAN14";
label variable POUFE14 "COVERED BY HOLDER OUTSIDE OF RU IN FEB14";
label variable POUMA14 "COVERED BY HOLDER OUTSIDE OF RU IN MAR14";
label variable POUAP14 "COVERED BY HOLDER OUTSIDE OF RU IN APR14";
label variable POUMY14 "COVERED BY HOLDER OUTSIDE OF RU IN MAY14";
label variable POUJU14 "COVERED BY HOLDER OUTSIDE OF RU IN JUN14";
label variable POUJL14 "COVERED BY HOLDER OUTSIDE OF RU IN JUL14";
label variable POUAU14 "COVERED BY HOLDER OUTSIDE OF RU IN AUG14";
label variable POUSE14 "COVERED BY HOLDER OUTSIDE OF RU IN SEP14";
label variable POUOC14 "COVERED BY HOLDER OUTSIDE OF RU IN OCT14";
label variable POUNO14 "COVERED BY HOLDER OUTSIDE OF RU IN NOV14";
label variable POUDE14 "COVERED BY HOLDER OUTSIDE OF RU IN DEC14";
label variable PRXJA14 "COV BY PRIV INS THROUGH EXCHNG IN JAN14";
label variable PRXFE14 "COV BY PRIV INS THROUGH EXCHNG IN FEB14";
label variable PRXMA14 "COV BY PRIV INS THROUGH EXCHNG IN MAR14";
label variable PRXAP14 "COV BY PRIV INS THROUGH EXCHNG IN APR14";
label variable PRXMY14 "COV BY PRIV INS THROUGH EXCHNG IN MAY14";
label variable PRXJU14 "COV BY PRIV INS THROUGH EXCHNG IN JUN14";
label variable PRXJL14 "COV BY PRIV INS THROUGH EXCHNG IN JUL14";
label variable PRXAU14 "COV BY PRIV INS THROUGH EXCHNG IN AUG14";
label variable PRXSE14 "COV BY PRIV INS THROUGH EXCHNG IN SEP14";
label variable PRXOC14 "COV BY PRIV INS THROUGH EXCHNG IN OCT14";
label variable PRXNO14 "COV BY PRIV INS THROUGH EXCHNG IN NOV14";
label variable PRXDE14 "COV BY PRIV INS THROUGH EXCHNG IN DEC14";
label variable PRIJA14 "COVERED BY PRIVATE INS IN JAN14";
label variable PRIFE14 "COVERED BY PRIVATE INS IN FEB14";
label variable PRIMA14 "COVERED BY PRIVATE INS IN MAR14";
label variable PRIAP14 "COVERED BY PRIVATE INS IN APR14";
label variable PRIMY14 "COVERED BY PRIVATE INS IN MAY14";
label variable PRIJU14 "COVERED BY PRIVATE INS IN JUN14";
label variable PRIJL14 "COVERED BY PRIVATE INS IN JUL14";
label variable PRIAU14 "COVERED BY PRIVATE INS IN AUG14";
label variable PRISE14 "COVERED BY PRIVATE INS IN SEP14";
label variable PRIOC14 "COVERED BY PRIVATE INS IN OCT14";
label variable PRINO14 "COVERED BY PRIVATE INS IN NOV14";
label variable PRIDE14 "COVERED BY PRIVATE INS IN DEC14";
label variable HPEJA14 "HOLDER OF EMPL UNION INS IN JAN14";
label variable HPEFE14 "HOLDER OF EMPL UNION INS IN FEB14";
label variable HPEMA14 "HOLDER OF EMPL UNION INS IN MAR14";
label variable HPEAP14 "HOLDER OF EMPL UNION INS IN APR14";
label variable HPEMY14 "HOLDER OF EMPL UNION INS IN MAY14";
label variable HPEJU14 "HOLDER OF EMPL UNION INS IN JUN14";
label variable HPEJL14 "HOLDER OF EMPL UNION INS IN JUL14";
label variable HPEAU14 "HOLDER OF EMPL UNION INS IN AUG14";
label variable HPESE14 "HOLDER OF EMPL UNION INS IN SEP14";
label variable HPEOC14 "HOLDER OF EMPL UNION INS IN OCT14";
label variable HPENO14 "HOLDER OF EMPL UNION INS IN NOV14";
label variable HPEDE14 "HOLDER OF EMPL UNION INS IN DEC14";
label variable HPDJA14 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN14";
label variable HPDFE14 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB14";
label variable HPDMA14 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR14";
label variable HPDAP14 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR14";
label variable HPDMY14 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY14";
label variable HPDJU14 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN14";
label variable HPDJL14 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL14";
label variable HPDAU14 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG14";
label variable HPDSE14 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP14";
label variable HPDOC14 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT14";
label variable HPDNO14 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV14";
label variable HPDDE14 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC14";
label variable HPNJA14 "HOLDER OF NONGROUP INS IN JAN14";
label variable HPNFE14 "HOLDER OF NONGROUP INS IN FEB14";
label variable HPNMA14 "HOLDER OF NONGROUP INS IN MAR14";
label variable HPNAP14 "HOLDER OF NONGROUP INS IN APR14";
label variable HPNMY14 "HOLDER OF NONGROUP INS IN MAY14";
label variable HPNJU14 "HOLDER OF NONGROUP INS IN JUN14";
label variable HPNJL14 "HOLDER OF NONGROUP INS IN JUL14";
label variable HPNAU14 "HOLDER OF NONGROUP INS IN AUG14";
label variable HPNSE14 "HOLDER OF NONGROUP INS IN SEP14";
label variable HPNOC14 "HOLDER OF NONGROUP INS IN OCT14";
label variable HPNNO14 "HOLDER OF NONGROUP INS IN NOV14";
label variable HPNDE14 "HOLDER OF NONGROUP INS IN DEC14";
label variable HPOJA14 "HOLDER OF OTHER GROUP INS IN JAN14";
label variable HPOFE14 "HOLDER OF OTHER GROUP INS IN FEB14";
label variable HPOMA14 "HOLDER OF OTHER GROUP INS IN MAR14";
label variable HPOAP14 "HOLDER OF OTHER GROUP INS IN APR14";
label variable HPOMY14 "HOLDER OF OTHER GROUP INS IN MAY14";
label variable HPOJU14 "HOLDER OF OTHER GROUP INS IN JUN14";
label variable HPOJL14 "HOLDER OF OTHER GROUP INS IN JUL14";
label variable HPOAU14 "HOLDER OF OTHER GROUP INS IN AUG14";
label variable HPOSE14 "HOLDER OF OTHER GROUP INS IN SEP14";
label variable HPOOC14 "HOLDER OF OTHER GROUP INS IN OCT14";
label variable HPONO14 "HOLDER OF OTHER GROUP INS IN NOV14";
label variable HPODE14 "HOLDER OF OTHER GROUP INS IN DEC14";
label variable HPSJA14 "HOLDER OF SELF-EMP-1 INS IN JAN14";
label variable HPSFE14 "HOLDER OF SELF-EMP-1 INS IN FEB14";
label variable HPSMA14 "HOLDER OF SELF-EMP-1 INS IN MAR14";
label variable HPSAP14 "HOLDER OF SELF-EMP-1 INS IN APR14";
label variable HPSMY14 "HOLDER OF SELF-EMP-1 INS IN MAY14";
label variable HPSJU14 "HOLDER OF SELF-EMP-1 INS IN JUN14";
label variable HPSJL14 "HOLDER OF SELF-EMP-1 INS IN JUL14";
label variable HPSAU14 "HOLDER OF SELF-EMP-1 INS IN AUG14";
label variable HPSSE14 "HOLDER OF SELF-EMP-1 INS IN SEP14";
label variable HPSOC14 "HOLDER OF SELF-EMP-1 INS IN OCT14";
label variable HPSNO14 "HOLDER OF SELF-EMP-1 INS IN NOV14";
label variable HPSDE14 "HOLDER OF SELF-EMP-1 INS IN DEC14";
label variable HPXJA14 "HOLDER OF PRIV INS THROUGH EXCH IN JAN14";
label variable HPXFE14 "HOLDER OF PRIV INS THROUGH EXCH IN FEB14";
label variable HPXMA14 "HOLDER OF PRIV INS THROUGH EXCH IN MAR14";
label variable HPXAP14 "HOLDER OF PRIV INS THROUGH EXCH IN APR14";
label variable HPXMY14 "HOLDER OF PRIV INS THROUGH EXCH IN MAY14";
label variable HPXJU14 "HOLDER OF PRIV INS THROUGH EXCH IN JUN14";
label variable HPXJL14 "HOLDER OF PRIV INS THROUGH EXCH IN JUL14";
label variable HPXAU14 "HOLDER OF PRIV INS THROUGH EXCH IN AUG14";
label variable HPXSE14 "HOLDER OF PRIV INS THROUGH EXCH IN SEP14";
label variable HPXOC14 "HOLDER OF PRIV INS THROUGH EXCH IN OCT14";
label variable HPXNO14 "HOLDER OF PRIV INS THROUGH EXCH IN NOV14";
label variable HPXDE14 "HOLDER OF PRIV INS THROUGH EXCH IN DEC14";
label variable HPRJA14 "HOLDER OF PRIVATE INSURANCE IN JAN14";
label variable HPRFE14 "HOLDER OF PRIVATE INSURANCE IN FEB14";
label variable HPRMA14 "HOLDER OF PRIVATE INSURANCE IN MAR14";
label variable HPRAP14 "HOLDER OF PRIVATE INSURANCE IN APR14";
label variable HPRMY14 "HOLDER OF PRIVATE INSURANCE IN MAY14";
label variable HPRJU14 "HOLDER OF PRIVATE INSURANCE IN JUN14";
label variable HPRJL14 "HOLDER OF PRIVATE INSURANCE IN JUL14";
label variable HPRAU14 "HOLDER OF PRIVATE INSURANCE IN AUG14";
label variable HPRSE14 "HOLDER OF PRIVATE INSURANCE IN SEP14";
label variable HPROC14 "HOLDER OF PRIVATE INSURANCE IN OCT14";
label variable HPRNO14 "HOLDER OF PRIVATE INSURANCE IN NOV14";
label variable HPRDE14 "HOLDER OF PRIVATE INSURANCE IN DEC14";
label variable INSJA14X "COVR BY HOSP/MED INS IN JAN14 (ED)";
label variable INSFE14X "COVR BY HOSP/MED INS IN FEB14 (ED)";
label variable INSMA14X "COVR BY HOSP/MED INS IN MAR14 (ED)";
label variable INSAP14X "COVR BY HOSP/MED INS IN APR14 (ED)";
label variable INSMY14X "COVR BY HOSP/MED INS IN MAY14 (ED)";
label variable INSJU14X "COVR BY HOSP/MED INS IN JUN14 (ED)";
label variable INSJL14X "COVR BY HOSP/MED INS IN JUL14 (ED)";
label variable INSAU14X "COVR BY HOSP/MED INS IN AUG14 (ED)";
label variable INSSE14X "COVR BY HOSP/MED INS IN SEP14 (ED)";
label variable INSOC14X "COVR BY HOSP/MED INS IN OCT14 (ED)";
label variable INSNO14X "COVR BY HOSP/MED INS IN NOV14 (ED)";
label variable INSDE14X "COVR BY HOSP/MED INS IN DEC14 (ED)";
label variable PRVEV14 "EVER HAVE PRIVATE INSURANCE DURING 14";
label variable TRIEV14 "EVER HAVE TRICARE/CHAMPVA DURING 14";
label variable MCREV14 "EVER HAVE MEDICARE DURING 14 (ED)";
label variable MCDEV14 "EVER HAVE MEDICAID/SCHIP DURING 14 (ED)";
label variable OPAEV14 "EVER HAVE OTHER PUBLIC A INS DURING 14";
label variable OPBEV14 "EVER HAVE OTHER PUBLIC B INS DURING 14";
label variable UNINS14 "UNINSURED ALL OF 14";
label variable INSCOV14 "HEALTH INSURANCE COVERAGE INDICATOR 14";
label variable INSURC14 "FULL YEAR INSURANCE COVERAGE STATUS 2014";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST14X "COVERED BY TRICARE STANDARD - 12/31/14";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR14X "COVERED BY TRICARE PRIME - 12/31/14";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX14X "COVERED BY TRICARE EXTRA - 12/31/14";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI14X "COVERED BY TRICARE FOR LIFE - 12/31/14";
label variable TRICH31X "COVERED BY CHAMPVA - R3/1";
label variable TRICH42X "COVERED BY CHAMPVA - R4/2";
label variable TRICH14X "COVERED BY TRICARE CHAMPVA - 12/31/14";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD14 "COV BY MEDICARE PMED BENEFIT - 12/31/14";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD14X "COV BY MCARE PMED BENEFIT-12/31/14 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB14 "COV BY MEDICARE PART B - 12/31/14";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO14 "COV BY MEDICARE MANAGED CARE - 12/31/14";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO14 "COVRED BY MEDICAID OR SCHIP HMO-12/31/14";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC14 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/14";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO14 "COVERED BY PRIVATE HMO - 12/31/14";
label variable FSAGT31 "ANYONE IN RU HAVE FSA - R3/1";
label variable HASFSA31 "PERSON IS FSA HOLDER - R3/1";
label variable FSAAMT31 "FSA TOTAL AMOUNT FOR RU - R3/1";
label variable PROBPY42 "FAMILY HAVING PROB PAYING MEDICAL BILLS";
label variable CRFMPY42 "FAMILY MED BILLS BEING PAID OVER TIME";
label variable PYUNBL42 "UNABLE TO PAY FAMILY MEDICAL BILLS";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 19 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 19 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 19 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 19 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 19 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 19 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 19 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 19 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 19 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 19 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 19 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 19 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 19 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 19 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 19 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 19 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 19 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 19 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PN 19 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 19 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 19 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 19 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 19 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR14X "COV BY TRICR/CHAMV - 12/31/14 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE/CHAMPVA - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE/CHAMPVA - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE/CHAMPVA - R5/3";
label variable TRIAT14X "ANY TIME COV TRICARE/CHAMPVA - 12/31/14";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID14 "COV BY MEDICAID OR SCHIP - 12/31/14";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID14X "COV BY MEDICAID OR SCHIP - 12/31/14 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE14 "COV BY MEDICARE - 12/31/14";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT(ED)";
label variable MCARE14X "COV BY MEDICARE - 12/31/14 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT14X "ANY TIME COV MEDICAID OR SCHIP-12/31/14";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT14 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/14";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT14 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/14";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA14 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/14";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB14 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/14";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK14 "COV BY PRIV INS (DK PLAN) - 12/31/14";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU14 "COV BY EMPL/UNION GRP INS - 12/31/14";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING14 "COV BY NON-GROUP INS - 12/31/14";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG14 "COV BY OTHER GROUP INS - 12/31/14";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS14 "COV BY SELF-EMP-1 INS - 12/31/14";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT14 "COV BY SOMEONE OUT OF RU - 12/31/14";
label variable PRSTX31 "COV BY PRIV EXCHANGE INS -R3/1 INT DT";
label variable PRSTX42 "COV BY PRIV EXCHANGE INS -R4/2 INT DT";
label variable PRSTX53 "PRIV EXCHANGE INS ON 12-31 R5/R3 INT DT";
label variable PRSTX14 "PRIV EXCHANGE INSURANCE ON 12/31/14";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV14 "COV BY PRIV HLTH INS - 12/31/14";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT14 "ANY TIME COV PRIVATE INS - 12/31/14";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB14X "COV BY PUBLIC INS - 12/31/14 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT14X "ANY TIME COV BY PUBLIC - 12/31/14";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS14X "INSURED - 12/31/14 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT14X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/14";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR14 "COV BY STATE-SPEC PROG - 12/31/14";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT14 "ANY TIME COV BY STATE INS - 12/31/14";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable DNTINS31 "DENTAL INS - RD 3/1 IN 14";
label variable DNTINS14 "DENTAL INS - R5/R3 UNTIL 12/31/14";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 14";
label variable PMDINS14 "PMED INS - R5/R3 UNTIL 12/31/14";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable TOTTCH14 "TOTAL HEALTH CARE CHARGES 14, EXCL RX";
label variable TOTEXP14 "TOTAL HEALTH CARE EXP 14";
label variable TOTSLF14 "TOTAL AMT PAID BY SELF/FAMILY 14";
label variable TOTMCR14 "TOTAL AMT PAID BY MEDICARE 14";
label variable TOTMCD14 "TOTAL AMT PAID BY MEDICAID 14";
label variable TOTPRV14 "TOTAL AMT PAID BY PRIVATE INS 14";
label variable TOTVA14 "TOTAL AMT PAID BY VA/CHAMPVA 14";
label variable TOTTRI14 "TOTAL AMT PAID BY TRICARE 14";
label variable TOTOFD14 "TOTAL AMT PAID BY OTHER FEDERAL 14";
label variable TOTSTL14 "TOTAL AMT PAID BY OTH ST/LOCAL 14";
label variable TOTWCP14 "TOTAL AMT PAID BY WORKERS COMP 14";
label variable TOTOPR14 "TOTAL AMT PAID BY OTHER PRIVATE 14";
label variable TOTOPU14 "TOTAL AMT PAID BY OTHER PUBLIC 14";
label variable TOTOSR14 "TOTAL AMT PAID BY OTHER SOURCES 14";
label variable TOTPTR14 "TOTAL AMT PAID BY PRV & TRI 14";
label variable TOTOTH14 "TOTAL AMT PAID BY OTH COMBINED 14";
label variable OBTOTV14 "# OFFICE-BASED PROVIDER VISITS 14";
label variable OBVTCH14 "OFFICE-BASED PROVIDER VISIT CHARGES 14";
label variable OBVEXP14 "TOTAL OFFICE-BASED EXP 14";
label variable OBVSLF14 "ALL OFFICE VISITS - SELF/FAMILY AMT 14";
label variable OBVMCR14 "ALL OFFICE VISITS - MEDICARE AMT 14";
label variable OBVMCD14 "ALL OFFICE VISITS - MEDICAID AMT 14";
label variable OBVPRV14 "ALL OFFICE VISITS - PRIVATE INS AMT 14";
label variable OBVVA14 "ALL OFFICE VISITS-VA/CHAMPVA AMT 14";
label variable OBVTRI14 "ALL OFFICE VISITS-TRICARE AMT 14";
label variable OBVOFD14 "ALL OFFICE VISITS-OTHER FEDERAL AMT 14";
label variable OBVSTL14 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 14";
label variable OBVWCP14 "ALL OFFICE VISITS - WORKERS COMP AMT 14";
label variable OBVOPR14 "ALL OFFICE VISITS - OTH PRIVATE AMT 14";
label variable OBVOPU14 "ALL OFFICE VISITS - OTH PUBLIC AMT 14";
label variable OBVOSR14 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 14";
label variable OBVPTR14 "ALL OFFICE VISITS - PRV & TRI AMT 14";
label variable OBVOTH14 "ALL OFFICE VISITS - OTH COMBINED AMT 14";
label variable OBDRV14 "# OFFICE-BASED PHYSICIAN VISITS 14";
label variable OBDTCH14 "OFFICE-BASED PHYSICIAN VISIT CHARGES 14";
label variable OBDEXP14 "TOTAL OFF-BASED DR EXP 14";
label variable OBDSLF14 "DR OFFICE VISITS - SELF/FAMILY AMT 14";
label variable OBDMCR14 "DR OFFICE VISITS - MEDICARE AMT 14";
label variable OBDMCD14 "DR OFFICE VISITS - MEDICAID AMT 14";
label variable OBDPRV14 "DR OFFICE VISITS - PRIVATE INS AMT 14";
label variable OBDVA14 "DR OFFICE VISITS - VA/CHAMPVA AMT 14";
label variable OBDTRI14 "DR OFFICE VISITS - TRICARE AMT 14";
label variable OBDOFD14 "DR OFFICE VISITS - OTHER FEDERAL AMT 14";
label variable OBDSTL14 "DR OFFICE VISITS - OTH ST/LOCAL AMT 14";
label variable OBDWCP14 "DR OFFICE VISITS - WORKERS COMP AMT 14";
label variable OBDOPR14 "DR OFFICE VISITS - OTH PRIVATE AMT 14";
label variable OBDOPU14 "DR OFFICE VISITS - OTH PUBLIC AMT 14";
label variable OBDOSR14 "DR OFF VSTS - OTH UNCLASS SRCE AMT 14";
label variable OBDPTR14 "DR OFFICE VISITS - PRV & TRI AMT 14";
label variable OBDOTH14 "DR OFFICE VISITS - OTH COMBINED AMT 14";
label variable OBOTHV14 "# OFFICE-BASED NON-PHYSICAN VISITS 14";
label variable OBOTCH14 "OFFICE-BASED NON-DR VISIT CHARGES 14";
label variable OBOEXP14 "TOTAL OFF-BASED NON-DR EXP 14";
label variable OBOSLF14 "NON-DR OFF VISTS - SELF/FAMILY AMT 14";
label variable OBOMCR14 "NON-DR OFF VISTS - MEDICARE AMT 14";
label variable OBOMCD14 "NON-DR OFF VISTS - MEDICAID AMT 14";
label variable OBOPRV14 "NON-DR OFF VISTS - PRIVATE INS AMT 14";
label variable OBOVA14 "NON-DR OFF VISTS - VA/CHAMPVA AMT 14";
label variable OBOTRI14 "NON-DR OFF VISTS - TRICARE AMT 14";
label variable OBOOFD14 "NON-DR OFF VISTS - OTHER FEDERAL AMT 14";
label variable OBOSTL14 "NON-DR OFF VISTS - OTH ST/LOCAL AMT 14";
label variable OBOWCP14 "NON-DR OFF VISTS - WORKERS COMP AMT 14";
label variable OBOOPR14 "NON-DR OFF VISTS - OTH PRIVATE AMT 14";
label variable OBOOPU14 "NON-DR OFF VISTS - OTH PUBLIC AMT 14";
label variable OBOOSR14 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 14";
label variable OBOPTR14 "NON-DR OFF VISTS - PRV & TRI AMT 14";
label variable OBOOTH14 "NON-DR OFF VISTS - OTH COMBINED AMT 14";
label variable OBCHIR14 "# OFFICE-BASED CHIROPRACTOR VISITS 14";
label variable OBCTCH14 "OFFICE-BASED CHIRO VISIT CHARGES 14";
label variable OBCEXP14 "TOTAL OFF-BASED CHIRO EXP 14";
label variable OBCSLF14 "CHIRO OFF VISITS - SELF/FAMILY AMT 14";
label variable OBCMCR14 "CHIRO OFF VISITS - MEDICARE AMT 14";
label variable OBCMCD14 "CHIRO OFF VISITS - MEDICAID AMT 14";
label variable OBCPRV14 "CHIRO OFF VISITS - PRIVATE INS AMT 14";
label variable OBCVA14 "CHIRO OFF VISITS - VA/CHAMPVA AMT 14";
label variable OBCTRI14 "CHIRO OFF VISITS - TRICARE AMT 14";
label variable OBCOFD14 "CHIRO OFF VISITS - OTHER FEDERAL AMT 14";
label variable OBCSTL14 "CHIRO OFF VISITS - OTH ST/LOCAL AMT 14";
label variable OBCWCP14 "CHIRO OFF VISITS - WORKERS COMP AMT 14";
label variable OBCOPR14 "CHIRO OFF VISTS - OTHR PRIVATE AMT 14";
label variable OBCOPU14 "CHIRO OFF VISTS - OTHR PUBLIC AMT 14";
label variable OBCOSR14 "CHIRO OFF VSTS-OTHR UNCLASS SRCE AMT 14";
label variable OBCPTR14 "CHIRO OFF VISITS - PRV & TRI AMT 14";
label variable OBCOTH14 "CHIRO OFF VISITS -OTH COMBINED AMT 14";
label variable OBNURS14 "# OFF-BASED NURSE/PRACTITIONER VISITS 14";
label variable OBNTCH14 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 14";
label variable OBNEXP14 "TOTAL OFF-BASED NURSE/PRAC 14";
label variable OBNSLF14 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 14";
label variable OBNMCR14 "NURSE/PRAC OFF VISITS - MEDICARE AMT 14";
label variable OBNMCD14 "NURSE/PRAC OFF VSTS - MEDICAID AMT 14";
label variable OBNPRV14 "NURSE/PRAC OFF VSTS-PRIVATE INS AMT 14";
label variable OBNVA14 "NURSE/PRAC OFF VSTS - VA/CHAMPVA AMT 14";
label variable OBNTRI14 "NURSE/PRAC OFF VSTS - TRICARE AMT 14";
label variable OBNOFD14 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 14";
label variable OBNSTL14 "NURSE/PRAC OFF VSTS-OTH ST/LOCAL AMT 14";
label variable OBNWCP14 "NURSE/PRAC OFF VSTS-WORKERS COMP AMT 14";
label variable OBNOPR14 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 14";
label variable OBNOPU14 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 14";
label variable OBNOSR14 "NRS/PR OFF VSTS-OTH UNCLASS SRCE AMT 14";
label variable OBNPTR14 "NURSE/PRAC OFF VSTS - PRV & TRI AMT 14";
label variable OBNOTH14 "NURSE/PRAC OFF VSTS-OTH COMBINED AMT 14";
label variable OBOPTO14 "# OFF-BASED OPTOMETRIST VISITS 14";
label variable OBETCH14 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 14";
label variable OBEEXP14 "TOTAL OFF-BASED OPTOMETRIST EXP 14";
label variable OBESLF14 "OPTOMETRIST OFF VSTS-SELF/FAMILY AMT 14";
label variable OBEMCR14 "OPTOMETRIST OFF VSTS - MEDICARE AMT 14";
label variable OBEMCD14 "OPTOMETRIST OFF VSTS - MEDICAID AMT 14";
label variable OBEPRV14 "OPTOMETRIST OFF VSTS-PRIVATE INS AMT 14";
label variable OBEVA14 "OPTOMETRIST OFF VSTS - VA/CHAMPVA AMT 14";
label variable OBETRI14 "OPTOMETRIST OFF VSTS - TRICARE AMT 14";
label variable OBEOFD14 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 14";
label variable OBESTL14 "OPTOMETRIST OFF VSTS-OTH ST/LOCL AMT 14";
label variable OBEWCP14 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 14";
label variable OBEOPR14 "OPTOMETRIST OFF VSTS-OTH PRIVATE AMT 14";
label variable OBEOPU14 "OPTOMETRIST OFF VSTS - OTH PUBLIC AMT 14";
label variable OBEOSR14 "OPTOM OFF VSTS-OTH UNCLASS SRCE AMT 14";
label variable OBEPTR14 "OPTOMETRIST OFF VSTS - PRV & TRI AMT 14";
label variable OBEOTH14 "OPTOMETRIST OFF VSTS-OTH COMBINED AMT 14";
label variable OBASST14 "# OFF-BASED PHYSICIAN ASSIST VISITS 14";
label variable OBATCH14 "OFFICE-BASED PHYS ASST VISIT CHARGES 14";
label variable OBAEXP14 "TOTAL OFF-BASED PHYS ASS T EXP 14";
label variable OBASLF14 "PHYS ASS T OFF VSTS - SELF/FAMILY AMT 14";
label variable OBAMCR14 "PHYS ASS T OFF VSTS - MEDICARE AMT 14";
label variable OBAMCD14 "PHYS ASS T OFF VSTS - MEDICAID AMT 14";
label variable OBAPRV14 "PHYS ASS T OFF VSTS - PRIVATE INS AMT 14";
label variable OBAVA14 "PHYS ASS T OFF VSTS - VA/CHAMPVA AMT 14";
label variable OBATRI14 "PHYS ASS T OFF VSTS - TRICARE AMT 14";
label variable OBAOFD14 "PHYS ASS T OFF VSTS - OTHER FED AMT 14";
label variable OBASTL14 "PHYS ASS T OFF VSTS - OTH ST/LOCL AMT 14";
label variable OBAWCP14 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 14";
label variable OBAOPR14 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 14";
label variable OBAOPU14 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 14";
label variable OBAOSR14 "P A OFF VSTS - OTH UNCLASS SRCE AMT 14";
label variable OBAPTR14 "PHYS ASST OFF VSTS - PRV & TRI AMT 14";
label variable OBAOTH14 "PHYS ASST OFF VSTS - OTH COMBINED AMT 14";
label variable OBTHER14 "# OFF-BASED PT/OT VISITS 14";
label variable OBTTCH14 "OFFICE-BASED PT/OC VISIT CHARGES 14";
label variable OBTEXP14 "TOT OFF-BASED PT EXP 14";
label variable OBTSLF14 "PT/OT OFF VISITS - SELF/FAMILY AMT 14";
label variable OBTMCR14 "PT/OT OFF VISITS - MEDICARE AMT 14";
label variable OBTMCD14 "PT/OT OFF VISITS - MEDICAID AMT 14";
label variable OBTPRV14 "PT/OT OFF VISITS - PRIVATE INS AMT 14";
label variable OBTVA14 "PT/OT OFF VISITS - VA/CHAMPVA AMT 14";
label variable OBTTRI14 "PT/OT OFF VISITS - TRICARE AMT 14";
label variable OBTOFD14 "PT/OT OFF VISITS - OTHER FED AMT 14";
label variable OBTSTL14 "PT/OT OFF VISITS - OTH ST/LOCL AMT 14";
label variable OBTWCP14 "PT/OT OFF VISITS - WORKERS COMP AMT 14";
label variable OBTOPR14 "PT/OT OFF VISITS - OTH PRIVATE AMT 14";
label variable OBTOPU14 "PT/OT OFF VISITS - OTH PUBLIC AMT 14";
label variable OBTOSR14 "PT/OT OFF VSTS-OTH UNCLASS SRCE AMT 14";
label variable OBTPTR14 "PT/OT OFF VISITS - PRV & TRI AMT 14";
label variable OBTOTH14 "PT/OT OFF VISITS - OTH COMBINED AMT 14";
label variable OPTOTV14 "# OUTPATIENT DEPT PROVIDER VISITS 14";
label variable OPTTCH14 "OPD FACILITY + DR VISIT CHARGES - 14";
label variable OPTEXP14 "TOTAL OUTPATIENT FAC + DR EXP 14";
label variable OPTSLF14 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 14";
label variable OPTMCR14 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 14";
label variable OPTMCD14 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 14";
label variable OPTPRV14 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 14";
label variable OPTVA14 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 14";
label variable OPTTRI14 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 14";
label variable OPTOFD14 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 14";
label variable OPTSTL14 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 14";
label variable OPTWCP14 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 14";
label variable OPTOPR14 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 14";
label variable OPTOPU14 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 14";
label variable OPTOSR14 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 14";
label variable OPTPTR14 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 14";
label variable OPTOTH14 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 14";
label variable OPFTCH14 "OPD PROVIDER VISIT CHARGES - FAC 14";
label variable OPFEXP14 "TOTAL OUTPATIENT FACILITY EXP 14";
label variable OPFSLF14 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 14";
label variable OPFMCR14 "ALL OPD VISITS-MEDICARE AMT-FAC 14";
label variable OPFMCD14 "ALL OPD VISITS-MEDICAID AMT-FAC 14";
label variable OPFPRV14 "ALL OPD VISITS-PRIV INS AMT-FAC 14";
label variable OPFVA14 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 14";
label variable OPFTRI14 "ALL OPD VISITS-TRICARE AMT-FAC 14";
label variable OPFOFD14 "ALL OPD VISITS-OTHER FED AMT-FAC 14";
label variable OPFSTL14 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 14";
label variable OPFWCP14 "ALL OPD VISITS-WORKERS COMP AMT-FAC 14";
label variable OPFOPR14 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 14";
label variable OPFOPU14 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 14";
label variable OPFOSR14 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 14";
label variable OPFPTR14 "ALL OPD VISITS - PRV & TRI AMT-FAC 14";
label variable OPFOTH14 "ALL OPD VISITS - OTH COMBINED AMT-FAC 14";
label variable OPDEXP14 "TOTAL OUTPATIENT PROVIDER EXP 14";
label variable OPDTCH14 "OPD PROVIDER VISIT CHARGES - DR 14";
label variable OPDSLF14 "ALL OPD VISITS-SELF/FAMILY AMT-DR 14";
label variable OPDMCR14 "ALL OPD VISITS-MEDICARE AMT-DR 14";
label variable OPDMCD14 "ALL OPD VISITS-MEDICAID AMT-DR 14";
label variable OPDPRV14 "ALL OPD VISITS-PRIV INS AMT-DR 14";
label variable OPDVA14 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 14";
label variable OPDTRI14 "ALL OPD VISITS-TRICARE AMT-DR 14";
label variable OPDOFD14 "ALL OPD VISITS-OTHER FED AMT-DR 14";
label variable OPDSTL14 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 14";
label variable OPDWCP14 "ALL OPD VISITS-WORKERS COMP AMT-DR 14";
label variable OPDOPR14 "ALL OPD VISITS - OTH PRIVATE AMT-DR 14";
label variable OPDOPU14 "ALL OPD VISITS-OTH PUBLIC AMT-DR 14";
label variable OPDOSR14 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 14";
label variable OPDPTR14 "ALL OPD VISITS-PRV & TRI AMT -DR 14";
label variable OPDOTH14 "ALL OPD VISITS-OTH COMBINED AMT-DR 14";
label variable OPDRV14 "# OUTPATIENT DEPT PHYSICIAN VISITS 14";
label variable OPVTCH14 "OPD PHYSICIAN VISIT CHARGES - FAC 14";
label variable OPVEXP14 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 14";
label variable OPVSLF14 "OPD DR VISITS-SELF/FAMILY AMT-FAC 14";
label variable OPVMCR14 "OPD DR VISITS-MEDICARE AMT-FAC 14";
label variable OPVMCD14 "OPD DR VISITS-MEDICAID AMT-FAC 14";
label variable OPVPRV14 "OPD DR VISITS-PRIV INS AMT-FAC 14";
label variable OPVVA14 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 14";
label variable OPVTRI14 "OPD DR VISITS-TRICARE AMT-FAC 14";
label variable OPVOFD14 "OPD DR VISITS-OTHER FED AMT-FAC 14";
label variable OPVSTL14 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 14";
label variable OPVWCP14 "OPD DR VISITS-WORKERS COMP AMT-FAC 14";
label variable OPVOPR14 "OPD DR VISITS - OTH PRIVATE AMT-FAC 14";
label variable OPVOPU14 "OPD DR VISITS-OTH PUBLIC AMT-FAC 14";
label variable OPVOSR14 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 14";
label variable OPVPTR14 "OPD DR VISITS - PRV & TRI AMT-FAC 14";
label variable OPVOTH14 "OPD DR VISITS - OTH COMBINED AMT-FAC 14";
label variable OPSEXP14 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 14";
label variable OPSTCH14 "OPD PHYSICIAN VISIT CHARGES - DR 14";
label variable OPSSLF14 "OPD DR VISITS-SELF/FAMILY AMT-DR 14";
label variable OPSMCR14 "OPD DR VISITS-MEDICARE AMT-DR 14";
label variable OPSMCD14 "OPD DR VISITS-MEDICAID AMT-DR 14";
label variable OPSPRV14 "OPD DR VISITS-PRIV INS AMT-DR 14";
label variable OPSVA14 "OPD DR VISITS-VA/CHAMPVA AMT-DR 14";
label variable OPSTRI14 "OPD DR VISITS-TRICARE AMT-DR 14";
label variable OPSOFD14 "OPD DR VISITS-OTHER FED AMT-DR 14";
label variable OPSSTL14 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 14";
label variable OPSWCP14 "OPD DR VISITS-WORKERS COMP AMT-DR 14";
label variable OPSOPR14 "OPD DR VISITS - OTH PRIVATE AMT-DR 14";
label variable OPSOPU14 "OPD DR VISITS-OTH PUBLIC AMT-DR 14";
label variable OPSOSR14 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 14";
label variable OPSPTR14 "OPD DR VISITS - PRV & TRI AMT-DR 14";
label variable OPSOTH14 "OPD DR VISITS -OTH COMBINED AMT-DR 14";
label variable OPOTHV14 "# OUTPATIENT DEPT NON-DR VISITS 14";
label variable OPOTCH14 "OPD NON-PHYS VISIT CHARGES - FAC 14";
label variable OPOEXP14 "TOTAL OUTPATIENT NON-DR - FAC EXP 14";
label variable OPOSLF14 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 14";
label variable OPOMCR14 "OPD NON-DR VISITS-MEDICARE AMT-FAC 14";
label variable OPOMCD14 "OPD NON-DR VISITS-MEDICAID AMT-FAC 14";
label variable OPOPRV14 "OPD NON-DR VISITS-PRIV INS AMT-FAC 14";
label variable OPOVA14 "OPD NON-DR VISITS-VA/CHAMPVA AMT-FAC 14";
label variable OPOTRI14 "OPD NON-DR VISITS-TRICARE AMT-FAC 14";
label variable OPOOFD14 "OPD NON-DR VISITS-OTHER FED AMT-FAC 14";
label variable OPOSTL14 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 14";
label variable OPOWCP14 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 14";
label variable OPOOPR14 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 14";
label variable OPOOPU14 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 14";
label variable OPOOSR14 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 14";
label variable OPOPTR14 "OPD NON-DR VISITS - PRV & TRI AMT-FAC 14";
label variable OPOOTH14 "OPD NON-DR VISITS-OTH COMBINED AM-FAC 14";
label variable OPPEXP14 "TOTAL OUTPATIENT NON-DR - DR EXP 14";
label variable OPPTCH14 "OPD NON-PHYS VISIT CHARGES - DR 14";
label variable OPPSLF14 "OPD NON-DR VISITS-SELF/FAM AMT-DR 14";
label variable OPPMCR14 "OPD NON-DR VISITS-MEDICARE AMT-DR 14";
label variable OPPMCD14 "OPD NON-DR VISITS-MEDICAID AMT-DR 14";
label variable OPPPRV14 "OPD NON-DR VISITS-PRIV INS AMT-DR 14";
label variable OPPVA14 "OPD NON-DR VISITS-VA/CHAMPVA AMT-DR 14";
label variable OPPTRI14 "OPD NON-DR VISITS-TRICARE AMT-DR 14";
label variable OPPOFD14 "OPD NON-DR VISITS-OTHER FED AMT-DR 14";
label variable OPPSTL14 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 14";
label variable OPPWCP14 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 14";
label variable OPPOPR14 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 14";
label variable OPPOPU14 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 14";
label variable OPPOSR14 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 14";
label variable OPPPTR14 "OPD NON-DR VISITS - PRV & TRI AMT-DR 14";
label variable OPPOTH14 "OPD NON-DR VISITS-OTH COMBINED AMT-DR 14";
label variable AMCHIR14 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2014";
label variable AMCTCH14 "CHIRO AMBULATORY VISIT CHARGES 14";
label variable AMCEXP14 "TOTL AMBULTRY (OB+OP) CHIRO EXP 14";
label variable AMCSLF14 "CHIRO AMB VISITS - SELF/FAMILY AMT 14";
label variable AMCMCR14 "CHIRO AMB VISITS - MEDICARE AMT 14";
label variable AMCMCD14 "CHIRO AMB VISITS - MEDICAID AMT 14";
label variable AMCPRV14 "CHIRO AMB VISITS - PRIVATE INS AMT 14";
label variable AMCVA14 "CHIRO AMB VISITS - VA/CHAMPVA AMT 14";
label variable AMCTRI14 "CHIRO AMB VISITS-TRICARE AMT 14";
label variable AMCOFD14 "CHIRO AMB VISITS - OTHER FEDERAL AMT 14";
label variable AMCSTL14 "CHIRO AMB VISITS - OTH ST/LOCAL AMT 14";
label variable AMCWCP14 "CHIRO AMB VISITS-WORKERS COMP AMT 14";
label variable AMCOPR14 "CHIRO AMB VISITS - OTH PRIVATE AMT 14";
label variable AMCOPU14 "CHIRO AMB VISITS - OTH PUBLIC AMT 14";
label variable AMCOSR14 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 14";
label variable AMCPTR14 "CHIRO AMB VISITS -PRV & TRI AMT 14";
label variable AMCOTH14 "CHIRO AMB VISITS - OTH COMBINED AMT 14";
label variable AMNURS14 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 14";
label variable AMNTCH14 "NRS/PRAC AMBULATORY VISIT CHARGES 14";
label variable AMNEXP14 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 14";
label variable AMNSLF14 "NRS/PRAC AMB VSTS - SELF/FAMILY AMT 14";
label variable AMNMCR14 "NRS/PRAC AMB VSTS - MEDICARE AMT 14";
label variable AMNMCD14 "NRS/PRAC AMB VSTS - MEDICAID AMT 14";
label variable AMNPRV14 "NRS/PRAC AMB VSTS - PRIV INS AMT 14";
label variable AMNVA14 "NRS/PRAC AMB VSTS-VA/CHAMPVA AMT 14";
label variable AMNTRI14 "NRS/PRAC AMB VSTS-TRICARE AMT 14";
label variable AMNOFD14 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 14";
label variable AMNSTL14 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 14";
label variable AMNWCP14 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 14";
label variable AMNOPR14 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 14";
label variable AMNOPU14 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 14";
label variable AMNOSR14 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 14";
label variable AMNPTR14 "NRS/PRAC AMB VSTS - PRV & TRI AMT 14";
label variable AMNOTH14 "NRS/PRAC AMB VSTS - OTH COMBINED AMT 14";
label variable AMOPTO14 "# AMB OPTOMETRIST VSTS (OB+OP) 14";
label variable AMETCH14 "OPTOMETRIST AMBULATORY VISIT CHARGES 14";
label variable AMEEXP14 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 14";
label variable AMESLF14 "OPTMTRIST AMB VSTS - SELF/FAMILY AMT 14";
label variable AMEMCR14 "OPTMTRIST AMB VSTS - MEDICARE AMT 14";
label variable AMEMCD14 "OPTMTRIST AMB VSTS - MEDICAID AMT 14";
label variable AMEPRV14 "OPTMTRIST AMB VSTS - PRIVATE INS AMT 14";
label variable AMEVA14 "OPTMTRIST AMB VSTS-VA/CHAMPVA AMT 14";
label variable AMETRI14 "OPTMTRIST AMB VSTS-TRICARE AMT 14";
label variable AMEOFD14 "OPTMTRIST AMB VSTS-OTHER FED AMT 14";
label variable AMESTL14 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 14";
label variable AMEWCP14 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 14";
label variable AMEOPR14 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 14";
label variable AMEOPU14 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 14";
label variable AMEOSR14 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 14";
label variable AMEPTR14 "OPTMTRIST AMB VSTS - PRV & TRI AMT 14";
label variable AMEOTH14 "OPTMTRIST AMB VSTS - OTH COMBINED AMT 14";
label variable AMASST14 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2014";
label variable AMATCH14 "PHYS ASS T AMBULATORY VISIT CHARGES 14";
label variable AMAEXP14 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 14";
label variable AMASLF14 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 14";
label variable AMAMCR14 "PHYS ASS T AMB VSTS-MEDICARE AMT 14";
label variable AMAMCD14 "PHYS ASS T AMB VSTS-MEDICAID AMT 14";
label variable AMAPRV14 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 14";
label variable AMAVA14 "PHYS ASS T AMB VSTS-VA/CHAMPVA AMT 14";
label variable AMATRI14 "PHYS ASS T AMB VSTS-TRICARE AMT 14";
label variable AMAOFD14 "PHYS ASS T AMB VSTS - OTHER FED AMT 14";
label variable AMASTL14 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 14";
label variable AMAWCP14 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 14";
label variable AMAOPR14 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 14";
label variable AMAOPU14 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 14";
label variable AMAOSR14 "P A AMB VSTS - OTH UNCLASS SRCE AMT 14";
label variable AMAPTR14 "PHYS ASS T AMB VSTS - PRV & TRI AMT 14";
label variable AMAOTH14 "PHYS ASS T AMB VSTS-OTH COMBINED AMT 14";
label variable AMTHER14 "# AMB PT/OT THRPY VISITS (OB+OP) 14";
label variable AMTTCH14 "PT/OC AMBULATORY VISIT CHARGES 14";
label variable AMTEXP14 "TOTL AMBULTRY (OB+OP) PT/OT EXP 14";
label variable AMTSLF14 "PT/OT AMB VISITS-SELF/FAMILY AMT 14";
label variable AMTMCR14 "PT/OT AMB VISITS-MEDICARE AMT 14";
label variable AMTMCD14 "PT/OT AMB VISITS-MEDICAID AMT 14";
label variable AMTPRV14 "PT/OT AMB VISITS-PRIVATE INS AMT 14";
label variable AMTVA14 "PT/OT AMB VISITS-VA/CHAMPVA AMT 14";
label variable AMTTRI14 "PT/OT AMB VISITS-TRICARE AMT 14";
label variable AMTOFD14 "PT/OT AMB VISITS - OTHER FED AMT 14";
label variable AMTSTL14 "PT/OT AMB VISITS-OTH ST/LOCL AMT 14";
label variable AMTWCP14 "PT/OT AMB VISITS-WORKERS COMP AMT 14";
label variable AMTOPR14 "PT/OT AMB VISITS - OTH PRIVATE AMT 14";
label variable AMTOPU14 "PT/OT AMB VISITS-OTH PUBLIC AMT 14";
label variable AMTOSR14 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 14";
label variable AMTPTR14 "PT/OT AMB VISITS -PRV & TRI AMT 14";
label variable AMTOTH14 "PT/OT AMB VISITS - OTH COMBINED AMT 14";
label variable AMTOTC14 "# CALLS W/OFFICE & OUPAT DEPTS, 2014";
label variable AMDRC14 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2014";
label variable ERTOT14 "# EMERGENCY ROOM VISITS 14";
label variable ERTTCH14 "ER FACILITY + DR VISIT CHARGES 14";
label variable ERTEXP14 "TOTAL ER FACILITY + DR EXP 14";
label variable ERTSLF14 "ER-SELF/FAMILY AMT-(FAC+DR) 14";
label variable ERTMCR14 "ER-MEDICARE AMT-(FAC+DR) 14";
label variable ERTMCD14 "ER-MEDICAID AMT-(FAC+DR) 14";
label variable ERTPRV14 "ER-PRIV INS AMT-(FAC+DR) 14";
label variable ERTVA14 "ER-VA/CHAMPVA AMT-(FAC+DR) 14";
label variable ERTTRI14 "ER-TRICARE AMT-(FAC+DR) 14";
label variable ERTOFD14 "ER-OTHER FED AMT-(FAC+DR) 14";
label variable ERTSTL14 "ER-OTH ST/LOCAL AMT-(FAC+DR) 14";
label variable ERTWCP14 "ER-WORKERS COMP AMT-(FAC+DR) 14";
label variable ERTOPR14 "ER-OTH PRIVATE AMT-(FAC+DR) 14";
label variable ERTOPU14 "ER-OTH PUBLIC AMT-(FAC+DR) 14";
label variable ERTOSR14 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 14";
label variable ERTPTR14 "ER-PRV & TRI AMT (FAC+DR) 14";
label variable ERTOTH14 "ER -OTH COMBINED AMT (FAC+DR) 14";
label variable ERFTCH14 "ER FACILITY VISIT CHARGES 14";
label variable ERFEXP14 "TOTAL ER FACILITY EXP 14";
label variable ERFSLF14 "ER-SELF/FAMILY AMT - FAC 14";
label variable ERFMCR14 "ER-MEDICARE AMT - FAC 14";
label variable ERFMCD14 "ER-MEDICAID AMT - FAC 14";
label variable ERFPRV14 "ER-PRIVATE INS AMT - FAC 14";
label variable ERFVA14 "ER-VA/CHAMPVA AMT - FAC 14";
label variable ERFTRI14 "ER-TRICARE AMT - FAC 14";
label variable ERFOFD14 "ER-OTHER FEDERAL AMT - FAC 14";
label variable ERFSTL14 "ER-OTH ST/LOCAL AMT - FAC 14";
label variable ERFWCP14 "ER-WORKERS COMP AMT - FAC 14";
label variable ERFOPR14 "ER-OTHER PRIVATE AMT - FAC 14";
label variable ERFOPU14 "ER-OTHER PUBLIC AMT - FAC 14";
label variable ERFOSR14 "ER-OTH UNCLASS SRCE AMT - FAC 14";
label variable ERFPTR14 "ER-PRV & TRI AMT - FAC 14";
label variable ERFOTH14 "ER-OTH COMBINED AMT - FAC 14";
label variable ERDEXP14 "TOTAL EMERGENCY ROOM DR EXP 14";
label variable ERDTCH14 "ER DOCTOR VISIT CHARGES 14";
label variable ERDSLF14 "ER-SELF/FAMILY AMT - DR 14";
label variable ERDMCR14 "ER-MEDICARE AMT - DR 14";
label variable ERDMCD14 "ER-MEDICAID AMT - DR 14";
label variable ERDPRV14 "ER-PRIVATE INS AMT - DR 14";
label variable ERDVA14 "ER-VA/CHAMPVA AMT - DR 14";
label variable ERDTRI14 "ER-TRICARE AMT - DR 14";
label variable ERDOFD14 "ER-OTHER FED AMT - DR 14";
label variable ERDSTL14 "ER-OTH ST/LOCAL AMT - DR 14";
label variable ERDWCP14 "ER-WORKERS COMP AMT - DR 14";
label variable ERDOPR14 "ER - OTHER PRIVATE AMT - DR 14";
label variable ERDOPU14 "ER - OTHER PUBLIC AMT - DR 14";
label variable ERDOSR14 "ER-OTH UNCLASS SRCE AMT - DR 14";
label variable ERDPTR14 "ER-PRV & TRI AMT - DR 14";
label variable ERDOTH14 "ER-OTH COMBINED AMT - DR 14";
label variable IPZERO14 "# ZERO-NIGHT HOSPITAL STAYS 14";
label variable ZIFTCH14 "ZERO-NITE IP STAY CHARGES - FAC 14";
label variable ZIFEXP14 "TOTAL ZERO-NITE STAYS FAC EXP 14";
label variable ZIFSLF14 "ZERO-NITE IP STAZ-SELF/FAM AMT-FAC 14";
label variable ZIFMCR14 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 14";
label variable ZIFMCD14 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 14";
label variable ZIFPRV14 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 14";
label variable ZIFVA14 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-FAC 14";
label variable ZIFTRI14 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 14";
label variable ZIFOFD14 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 14";
label variable ZIFSTL14 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 14";
label variable ZIFWCP14 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 14";
label variable ZIFOPR14 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 14";
label variable ZIFOPU14 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 14";
label variable ZIFOSR14 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 14";
label variable ZIFPTR14 "ZERO-NITE IP STAZ-PRV & TRI AMT-FAC 14";
label variable ZIFOTH14 "ZERO-NITE IP STAZ-OTH COMBINE AMT-FAC 14";
label variable ZIDEXP14 "TOTAL ZERO-NITE STAZ DR 14";
label variable ZIDTCH14 "ZERO-NITE IP STAY CHARGES - DR 14";
label variable ZIDSLF14 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 14";
label variable ZIDMCR14 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 14";
label variable ZIDMCD14 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 14";
label variable ZIDPRV14 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 14";
label variable ZIDVA14 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-DR 14";
label variable ZIDTRI14 "ZERO-NITE IP STAZ-TRICARE AMT-DR 14";
label variable ZIDOFD14 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 14";
label variable ZIDSTL14 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 14";
label variable ZIDWCP14 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 14";
label variable ZIDOPR14 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 14";
label variable ZIDOPU14 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 14";
label variable ZIDOSR14 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 14";
label variable ZIDPTR14 "ZERO-NITE IP STAZ-PRV & TRI AMT-DR 14";
label variable ZIDOTH14 "ZERO-NITE IP STAZ-OTH COMBINED AMT-DR 14";
label variable IPDIS14 "# HOSPITAL DISCHARGES, 2014";
label variable IPTEXP14 "TOT HOSP IP FACILITY + DR EXP 14";
label variable IPTTCH14 "IP HOSP STAY CHARGES (FAC+DR) 14";
label variable IPTSLF14 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 14";
label variable IPTMCR14 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 14";
label variable IPTMCD14 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 14";
label variable IPTPRV14 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 14";
label variable IPTVA14 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 14";
label variable IPTTRI14 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 14";
label variable IPTOFD14 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 14";
label variable IPTSTL14 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 14";
label variable IPTWCP14 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 14";
label variable IPTOPR14 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 14";
label variable IPTOPU14 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 14";
label variable IPTOSR14 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 14";
label variable IPTPTR14 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 14";
label variable IPTOTH14 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 14";
label variable IPFEXP14 "TOT HOSP IP FACILITY EXP-INC 0 NITES 14";
label variable IPFTCH14 "IP HOSP STAY CHARGES - FAC 14";
label variable IPFSLF14 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 14";
label variable IPFMCR14 "IP HOSP STAZ-MEDICARE AMT-FAC 14";
label variable IPFMCD14 "IP HOSP STAZ-MEDICAID AMT-FAC 14";
label variable IPFPRV14 "IP HOSP STAZ-PRIV INS AMT-FAC 14";
label variable IPFVA14 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 14";
label variable IPFTRI14 "IP HOSP STAZ-TRICARE AMT-FAC 14";
label variable IPFOFD14 "IP HOSP STAZ-OTHER FED AMT-FAC 14";
label variable IPFSTL14 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 14";
label variable IPFWCP14 "IP HOSP STAZ-WORKERS COMP AMT-FAC 14";
label variable IPFOPR14 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 14";
label variable IPFOPU14 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 14";
label variable IPFOSR14 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 14";
label variable IPFPTR14 "IP HOSP STAZ-PRV & TRI AMT-FAC 14";
label variable IPFOTH14 "IP HOSP STAZ-OTH COMBINED AMT-FAC 14";
label variable IPDEXP14 "TOTL HOSP STAZ DR EXP 14";
label variable IPDTCH14 "IP HOSP STAY CHARGES - DR 14";
label variable IPDSLF14 "IP HOSP STAZ-SELF/FAMILY AMT-DR 14";
label variable IPDMCR14 "IP HOSP STAZ-MEDICARE AMT- DR 14";
label variable IPDMCD14 "IP HOSP STAZ-MEDICAID AMT-DR 14";
label variable IPDPRV14 "IP HOSP STAZ-PRIV INS AMT-DR 14";
label variable IPDVA14 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 14";
label variable IPDTRI14 "IP HOSP STAZ-TRICARE AMT-DR 14";
label variable IPDOFD14 "IP HOSP STAZ-OTHER FED AMT-DR 14";
label variable IPDSTL14 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 14";
label variable IPDWCP14 "IP HOSP STAZ-WORKERS COMP AMT-DR 14";
label variable IPDOPR14 "IP HOSP STAZ - OTH PRIVATE AMT-DR 14";
label variable IPDOPU14 "IP HOSP STAZ - OTH PUBLIC AMT-DR 14";
label variable IPDOSR14 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 14";
label variable IPDPTR14 "IP HOSP STAZ-PRV & TRI AMT-DR 14";
label variable IPDOTH14 "IP HOSP STAZ-OTH COMBINED AMT-DR 14";
label variable IPNGTD14 "# NIGHTS IN HOSP FOR DISCHARGES, 2014";
label variable DVTOT14 "# DENTAL CARE VISITS 14";
label variable DVTTCH14 "TOTAL DENTAL CARE VISIT CHARGES 14";
label variable DVTEXP14 "TOTAL DENTAL CARE EXP 14";
label variable DVTSLF14 "ALL DENTAL CARE - SELF/FAMILY AMT 14";
label variable DVTMCR14 "ALL DENTAL CARE - MEDICARE AMT 14";
label variable DVTMCD14 "ALL DENTAL CARE - MEDICAID AMT 14";
label variable DVTPRV14 "ALL DENTAL CARE - PRIVATE INS AMT 14";
label variable DVTVA14 "ALL DENTAL CARE - VA/CHAMPVA AMT 14";
label variable DVTTRI14 "ALL DENTAL CARE - TRICARE AMT 14";
label variable DVTOFD14 "ALL DENTAL CARE - OTHER FEDRL AMT 14";
label variable DVTSTL14 "ALL DENTAL CARE - OTH ST/LOCAL AMT 14";
label variable DVTWCP14 "ALL DENTAL CARE - WORKERS COMP AMT 14";
label variable DVTOPR14 "ALL DENTAL CARE - OTH PRIVATE AMT 14";
label variable DVTOPU14 "ALL DENTAL CARE - OTH PUBLIC AMT 14";
label variable DVTOSR14 "ALL DENT CARE-OT UNCLASS SRCE AMT 14";
label variable DVTPTR14 "ALL DENTAL CARE - PRV & TRI AMT 14";
label variable DVTOTH14 "ALL DENTAL CARE - OTH COMBINED AMT 14";
label variable DVGEN14 "# GENERAL DENTIST VISITS 14";
label variable DVGTCH14 "GENERAL DENTAL CARE VISIT CHARGES 14";
label variable DVGEXP14 "TOTAL GENERAL DENTIST EXP 14";
label variable DVGSLF14 "GNRL DENTAL VISITS - SELF/FAM AMT 14";
label variable DVGMCR14 "GNRL DENTAL VISITS - MEDICARE AMT 14";
label variable DVGMCD14 "GNRL DENTAL VISITS - MEDICAID AMT 14";
label variable DVGPRV14 "GNRL DENTAL VISITS - PRIVATE INS AMT 14";
label variable DVGVA14 "GNRL DENTAL VISITS - VA/CHAMPVA AMT 14";
label variable DVGTRI14 "GNRL DENTAL VISITS-TRICARE AMT 14";
label variable DVGOFD14 "GNRL DENTAL VISITS - OTHER FED AMT 14";
label variable DVGSTL14 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 14";
label variable DVGWCP14 "GNRL DENTAL VISITS - WORKERS COMP AMT 14";
label variable DVGOPR14 "GNRL DENTAL VISITS - OTH PRIVATE AMT 14";
label variable DVGOPU14 "GNRL DENTAL VISITS - OTH PUBLIC AMT 14";
label variable DVGOSR14 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 14";
label variable DVGPTR14 "GNRL DENTAL VISITS - PRV & TRI AMT 14";
label variable DVGOTH14 "GNRL DENTAL VISITS - OTH COMBINED AMT 14";
label variable DVORTH14 "# ORTHODONTIST VISITS 14";
label variable DVOTCH14 "ORTHODONTIST VISIT CHARGES 14";
label variable DVOEXP14 "TOTAL ORTHODONTIST EXP 14";
label variable DVOSLF14 "ORTHODONTIST VISITS - SELF/FAMILY AMT 14";
label variable DVOMCR14 "ORTHODONTIST VISITS - MEDICARE AMT 14";
label variable DVOMCD14 "ORTHODONTIST VISITS - MEDICAID AMT 14";
label variable DVOPRV14 "ORTHODONTIST VISITS - PRIVATE INS AMT 14";
label variable DVOVA14 "ORTHODONTIST VISITS-VA/CHAMPVA AMT 14";
label variable DVOTRI14 "ORTHODONTIST VISITS-TRICARE AMT 14";
label variable DVOOFD14 "ORTHODONTIST VISITS-OTHR FED AMT 14";
label variable DVOSTL14 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 14";
label variable DVOWCP14 "ORTHODONTIST VISITS-WORKERS COMP AMT 14";
label variable DVOOPR14 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 14";
label variable DVOOPU14 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 14";
label variable DVOOSR14 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 14";
label variable DVOPTR14 "ORTHODONTIST VISITS - PRV & TRI AMT 14";
label variable DVOOTH14 "ORTHODONTIST VISITS-OTH COMBINED AMT 14";
label variable HHTOTD14 "# HOME HEALTH PROVIDER DAYS, 2014";
label variable HHAGD14 "# AGENCY HOME HEALTH PROVIDER DAYS 14";
label variable HHATCH14 "HOME HEALTH AGENCY VISIT CHARGES 14";
label variable HHAEXP14 "TOTAL HOME HEALTH AGENCY EXP 14";
label variable HHASLF14 "HOME HLTH AGENCY - SELF/FAMILY AMT 14";
label variable HHAMCR14 "HOME HLTH AGENCY - MEDICARE AMT 14";
label variable HHAMCD14 "HOME HLTH AGENCY - MEDICAID AMT 14";
label variable HHAPRV14 "HOME HLTH AGENCY - PRIVATE INS AMT 14";
label variable HHAVA14 "HOME HLTH AGENCY-VA/CHAMPVA AMT 14";
label variable HHATRI14 "HOME HLTH AGENCY-TRICARE AMT 14";
label variable HHAOFD14 "HOME HLTH AGENCY - OTHER FED AMT 14";
label variable HHASTL14 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 14";
label variable HHAWCP14 "HOME HLTH AGENCY - WORKERS COMP AMT 14";
label variable HHAOPR14 "HOME HLTH AGENCY - OTH PRIVATE AMT 14";
label variable HHAOPU14 "HOME HLTH AGENCY - OTH PUBLIC AMT 14";
label variable HHAOSR14 "H HLTH AGENCY - OT UNCLASS SRCE AMT 14";
label variable HHAPTR14 "HOME HLTH AGENCY - PRV & TRI AMT 14";
label variable HHAOTH14 "HOME HLTH AGENCY - OTH COMBINED AMT 14";
label variable HHINDD14 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 14";
label variable HHNTCH14 "HOME HEALTH NON-AGENCY VISIT CHARGES 14";
label variable HHNEXP14 "TOTAL HOME HEALTH NON-AGNCY EXP 14";
label variable HHNSLF14 "HOME HLTH NON-AGNCY - SELF/FAM AMT 14";
label variable HHNMCD14 "HOME HLTH NON-AGNCY - MEDICAID AMT 14";
label variable HHNMCR14 "HOME HLTH NON-AGNCY - MEDICARE AMT 14";
label variable HHNPRV14 "HOME HLTH NON-AGNCY - PRIV INS AMT 14";
label variable HHNVA14 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 14";
label variable HHNTRI14 "HOME HLTH NON-AGNCY-TRICARE AMT 14";
label variable HHNOFD14 "HOME HLTH NON-AGNCY-OTHR FED AMT 14";
label variable HHNSTL14 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 14";
label variable HHNWCP14 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 14";
label variable HHNOPR14 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 14";
label variable HHNOPU14 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 14";
label variable HHNOSR14 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 14";
label variable HHNPTR14 "HOME HLTH NON-AGNCY - PRV & TRI AMT 14";
label variable HHNOTH14 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 14";
label variable HHINFD14 "# INFORMAL HOME HEALTH PROVIDER DAYS 14";
label variable VISEXP14 "TOTAL GLASSES/CONTACT LENS EXP 14";
label variable VISTCH14 "GLASSES/CONTACT LENSES CHARGES 14";
label variable VISSLF14 "GLASSES/CNTCT LENSES -SELF/FAM AMT 14";
label variable VISMCR14 "GLASSES/CNTCT LENSES-MEDICARE AMT 14";
label variable VISMCD14 "GLASSES/CNTCT LENSES-MEDICAID AMT 14";
label variable VISPRV14 "GLASSES/CNTCT LENSES-PRIV INS AMT 14";
label variable VISVA14 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 14";
label variable VISTRI14 "GLASSES/LENSES-TRICARE AMT 14";
label variable VISOFD14 "GLASSES/CNTCT LENSES-OTHR FED AMT 14";
label variable VISSTL14 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 14";
label variable VISWCP14 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 14";
label variable VISOPR14 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 14";
label variable VISOPU14 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 14";
label variable VISOSR14 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 14";
label variable VISPTR14 "GLASSES/CNTCT LENSES-PRV & TRI AMT 14";
label variable VISOTH14 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 14";
label variable OTHTCH14 "OTHER EQUP/SUPPLIES CHARGES 14";
label variable OTHEXP14 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 14";
label variable OTHSLF14 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 14";
label variable OTHMCR14 "OTHER EQUP/SUPPLIES-MEDICARE AMT 14";
label variable OTHMCD14 "OTHER EQUP/SUPPLIES-MEDICAID AMT 14";
label variable OTHPRV14 "OTHER EQUP/SUPPLIES-PRIV INS AMT 14";
label variable OTHVA14 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 14";
label variable OTHTRI14 "OTHER EQUP/SUPPLY-TRICARE AMT 14";
label variable OTHOFD14 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 14";
label variable OTHSTL14 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 14";
label variable OTHWCP14 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 14";
label variable OTHOPR14 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 14";
label variable OTHOPU14 "OTHER EQUP/SUPPLY - OTH PUBLIC AMT 14";
label variable OTHOSR14 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 14";
label variable OTHPTR14 "OTHER EQUP/SUPPLY - PRV & TRI AMT 14";
label variable OTHOTH14 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 14";
label variable RXTOT14 "# PRESC MEDS INCL REFILLS 14";
label variable RXEXP14 "TOTAL RX-EXP 14";
label variable RXSLF14 "TOTAL RX-SELF/FAMILY AMT 14";
label variable RXMCR14 "TOTAL RX-MEDICARE AMT 14";
label variable RXMCD14 "TOTAL RX-MEDICAID AMT 14";
label variable RXPRV14 "TOTAL RX-PRIVATE INS AMT 14";
label variable RXVA14 "TOTAL RX-VA/CHAMPVA AMT 14";
label variable RXTRI14 "TOTAL RX-TRICARE AMT 14";
label variable RXOFD14 "TOTAL RX-OTHER FED AMT 14";
label variable RXSTL14 "TOTAL RX-OTHER ST/LOCAL AMT 14";
label variable RXWCP14 "TOTAL RX-WORKERS COMP AMT 14";
label variable RXOPR14 "TOTAL RX-OTH PRIVATE AMT 14";
label variable RXOPU14 "TOTAL RX-OTH PUBLIC AMT 14";
label variable RXOSR14 "TOT RX-OTH UNCLASS SRCE AMT 14";
label variable RXPTR14 "TOTAL RX-PRV & TRI AMT 14";
label variable RXOTH14 "TOTAL RX-OTH COMBINED AMT 14";
label variable PERWT14F "FINAL PERSON WEIGHT, 2014";
label variable FAMWT14F "FINAL FAMILY WEIGHT, 2014";
label variable FAMWT14C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/14";
label variable SAQWT14F "FINAL SAQ PERSON WEIGHT, 2014";
label variable DIABW14F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2014";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2014";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1710001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1710002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1710003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1710004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1710005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1710008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1710009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1710010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1710013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1710014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1710015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1710017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1710024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1710027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1710028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1710031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1710032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1710034X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1710035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1710039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1710040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1710042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1710043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1710044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1710045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1710046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1710047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1710049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1710050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1710052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1710053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1710056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1710058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1710061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1710062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1710063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1710064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710066X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710067X
         0 "0.00"
         100 "$1 - $100" ;

label define H1710068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710070X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H1710074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1710089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1710090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1710091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1710092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1710093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1710094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2013 "2013 YEAR"
         2014 "2014 YEAR" ;

label define H1710095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2014 "2014 YEAR" ;

label define H1710096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2014 "2014 YEAR"
         2015 "2015 YEAR" ;

label define H1710097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1710098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1710099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710101X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710103X
         -1 "-1 INAPPLICABLE, THOSE WHO ARE DEC/INSTD"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1710105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1710107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1710108X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1710109X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1710110X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1710111X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1710112X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1710113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1710114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1710115X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710123X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710126X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710129X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710130X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1710131X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1710138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710142X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1710143X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1710144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1710145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710150X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710154X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710155X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1710158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710173X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1710176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1710177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1710178X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710179X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710180X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710181X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1710182X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1710183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710186X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1710187X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1710189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710197X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1710199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710200X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710201X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710202X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1710203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710211X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1710213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1710214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1710215X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1710216X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1710217X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1710218X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710219X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1710222X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710223X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1710226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1710227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710228X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710229X
         -1 "-1 INAPPLICABLE"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1710230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1710231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE A1C BLOOD TEST" ;

label define H1710232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H1710241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710253X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8  DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710265X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710266X
         0 "0.00"
         793 "$1 - $793" ;

label define H1710267X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710268X
         0 "0.00"
         387 "$1 - $387" ;

label define H1710269X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710271X
         -1 "-1 INAPPLICABLE OR UNDER 5"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN/EQUAL TO 8TH GRADE"
         13 "13 GED OR HS GRAD"
         14 "14 BEYOND HS,COLLEGE(NO 4YR DEG),ASSOC DEG"
         15 "15 4-YEAR COLLEGE DEGREE, BACHELOR'S DEGREE"
         16 "16 MASTER'S, DOCTORATE, OR PROFESSIONAL DEG"
         2 "2 9 - 12TH GRADE, NO HS DIPLOMA OR GED" ;

label define H1710272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H1710273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN/EQUAL TO 8TH GRADE"
         10 "10 CHILD UNDER 5 YEARS OLD"
         2 "2 9-12TH GRADE, NO HIGH SCHOOL DIPLOMA"
         3 "3 GED OR EQUIVALENT"
         4 "4 HIGH SCHOOL DIPLOMA"
         5 "5 SOME COLLEGE, NO DEGREE"
         6 "6 ASSOC DEG: OCCUPATIONAL,TECH,VOCATIONAL"
         7 "7 ASSOCIATE DEGREE: ACADEMIC PROGRAM"
         8 "8 BACHELOR'S DEGREE (BA,AB,BS,BBA)"
         9 "9 MASTER'S, PROFESSIONAL, DOCTORAL DEGREE" ;

label define H1710274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1710275X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1710276X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1710277X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1710278X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1710279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1710282X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         34 "34 NOT EMPLOYED DURING RD 3/1" ;

label define H1710283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1710284X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         34 "34 NOT EMPLOYED DURING RD 4/2" ;

label define H1710285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1710286X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         34 "34 NOT EMPLOYED DURING RD 5/3" ;

label define H1710287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1710288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1710289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1710290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1710291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2013 "2013 YEAR"
         2014 "2014 YEAR" ;

label define H1710292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2013 "2013 YEAR"
         2014 "2014 YEAR" ;

label define H1710293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2014 "2014 YEAR" ;

label define H1710294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2014 "2014 YEAR"
         2015 "2015 YEAR" ;

label define H1710295X
         0 "0.00"
         6 "$1 - $6" ;

label define H1710296X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710298X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710301X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1710302X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1710303X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1710304X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1710305X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1710306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710307X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1710308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1710309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1710310X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1710311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1710312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1710313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1710316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1710319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1710320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1710321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1710322X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1710323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710324X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710325X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1710326X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710327X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710328X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710330X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710332X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710333X
         0 "0.00"
         469 "$1 - $469" ;

label define H1710334X
         0 "0.00"
         10852 "$1 - $10,852" ;

label define H1710335X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710336X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710337X
         0 "0.00"
         150 "$1 - $150" ;

label define H1710338X
         0 "0.00"
         474 "$1 - $474" ;

label define H1710339X
         0 "0.00"
         120 "$1 - $120" ;

label define H1710340X
         0 "0.00"
         222 "$1 - $222" ;

label define H1710341X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710344X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1710345X
         -1 "-1 INAPPLICABLE"
         1 "1 MEXICAN/MEX AMER/CHICANO-NO OTHER HISP"
         2 "2 PUERTO RICAN -NO OTHER HISP REPORTED"
         3 "3 CUBAN/CUBAN AMERICAN -NO OTHER HISP RPTD"
         4 "4 DOMINICAN -NO OTHER HISP REPORTED"
         5 "5 CENTRAL OR SOUTH AMERICAN -NO OTHER HISP"
         6 "6 OTH LAT AM/HISP/LATINO/SPNSH ORGN-NO OTH"
         8 "8 MULTIPLE HISPANIC GROUPS REPORTED"
         9 "9 NON-HISPANIC" ;

label define H1710346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1710347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1710348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1710349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1710350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710351X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710352X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710353X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710354X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710355X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710356X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710357X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710358X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710370X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710371X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710372X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710377X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710378X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710418X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710419X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710420X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710422X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710423X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710424X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710425X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710426X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710427X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710428X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710430X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710431X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710432X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710433X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710434X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710435X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710436X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710437X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1710438X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1710439X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1710440X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H1710441X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $78.00"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710442X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H1710443X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $78.00"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710444X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H1710445X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $78.00"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710446X
         0 "0 NO"
         1 "1 YES" ;

label define H1710447X
         0 "0 NO"
         1 "1 YES" ;

label define H1710448X
         0 "0 NO"
         1 "1 YES" ;

label define H1710449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710450X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710451X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710452X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY WELL"
         2 "2 WELL"
         3 "3 NOT WELL"
         4 "4 NOT AT ALL"
         5 "5 UNDER 5 IN ROUND 1 AND OTHLANG=1, INAPP" ;

label define H1710453X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710454X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710455X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710456X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1710457X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1710458X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1710459X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1710460X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1710461X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1710462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710463X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710464X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710465X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710472X
         1 "1 IN-SCOPE ON 12/31/2014"
         2 "2 NOT IN-SCOPE ON 12/31/2014" ;

label define H1710473X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/14"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1710474X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/14"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1710475X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/14"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1710476X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/14"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1710477X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2014"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2014" ;

label define H1710478X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1710479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710480X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710481X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710490X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710492X
         -1 "-1 INAPPLICABLE"
         1 "1 <65 ANY PRIVATE"
         2 "2 <65 PUBLIC ONLY"
         3 "3 <65 UNINSURED"
         4 "4 65+ EDITED MEDICARE ONLY"
         5 "5 65+ EDITED MEDICARE AND PRIVATE"
         6 "6 65+ EDITED MEDICARE AND OTH PUB ONLY"
         7 "7 65+ UNINSURED"
         8 "8 65+ NO MEDICARE AND ANY PUBLIC/PRIVATE" ;

label define H1710493X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710494X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1710495X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710496X
         0 "0.00"
         20 "$1 - $20" ;

label define H1710497X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710498X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710499X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1710500X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1710501X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1710502X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710503X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1710504X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1710505X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1710506X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710508X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710509X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710510X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710511X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1710512X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1710513X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710514X
         -1 "-1 INAPPLICABLE, THOSE WHO JOIN AFTER RND 1"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPANISH"
         2 "2 ANOTHER LANGUAGE" ;

label define H1710515X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710516X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1710517X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1710518X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1710519X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1710521X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1710522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1710523X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1710524X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1710525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710551X
         1 "1 YES"
         2 "2 NO" ;

label define H1710552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710554X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1710555X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1710556X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1710557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710559X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710562X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710563X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710565X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1710566X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1710567X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1710568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710582X
         1 "1 YES"
         2 "2 NO" ;

label define H1710583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710594X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710597X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710598X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710599X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710600X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710601X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710602X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710603X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710604X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710605X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710606X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710607X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710608X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710609X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710610X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1710611X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710612X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710613X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710614X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1710615X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710616X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1710617X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1710618X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710619X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1710620X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710621X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710622X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710623X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1710624X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1710625X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710626X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1710627X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1710628X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1710629X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1710630X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710631X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710632X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710633X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710634X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710635X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710636X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710637X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1710638X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1710639X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1710640X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710641X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710642X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1710643X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710644X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710645X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$78.00"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710646X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$78.00"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710647X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$78.00"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710648X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710649X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710650X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710651X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710652X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710653X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710654X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1710655X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710656X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710657X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710658X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710659X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710660X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1710662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1710663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1710664X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710665X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710666X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710667X
         0 "0.00"
         100 "$1 - $100" ;

label define H1710668X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710669X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710670X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710671X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710672X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710673X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1710674X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1710675X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1710676X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1710677X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1710678X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1710679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710683X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710685X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710687X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710688X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710689X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710690X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710691X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710692X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710693X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710694X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710695X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710699X
         1 "1 YES"
         2 "2 NO" ;

label define H1710700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710705X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710712X
         1 "1 YES"
         2 "2 NO" ;

label define H1710713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710722X
         0 "0.00"
         29 "$1 - $29" ;

label define H1710723X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710724X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710725X
         0 "0.00"
         29 "$1 - $29" ;

label define H1710726X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710727X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710728X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710729X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710730X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710731X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710732X
         -1 "-1 INAPPLICABLE, THOSE WHO JOIN AFTER RND 1"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710733X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710734X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710735X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1710736X
         0 "0.00"
         945 "$1 - $945" ;

label define H1710737X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710738X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710744X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710750X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710751X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710752X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710755X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710756X
         18 "18 PANEL 18"
         19 "19 PANEL 19" ;

label define H1710757X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1710758X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710759X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710760X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710761X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710762X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710763X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710764X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710765X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710766X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710767X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710768X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710769X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710770X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710771X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710772X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710773X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710774X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710775X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710776X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710777X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710778X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710779X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710780X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710781X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710782X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710783X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710784X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710785X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710786X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710787X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710789X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710790X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710791X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710792X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710793X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1710794X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1710795X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710796X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710797X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1710798X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710799X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710800X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710801X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1710802X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710803X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710804X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710805X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1710806X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1710807X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1710808X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710809X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710810X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710811X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710812X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1710813X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710814X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710815X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710816X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710817X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710818X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710819X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710820X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710821X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710822X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710823X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710824X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710825X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710826X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710827X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710828X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710829X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710830X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710831X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710832X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710833X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710834X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710835X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710836X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710837X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710838X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710839X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710840X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710841X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710846X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710849X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1710850X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710851X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710852X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710853X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710854X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710855X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710856X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710857X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710859X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710861X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710863X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710864X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710865X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710866X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710868X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710872X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710873X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710874X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710876X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710877X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710878X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710879X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710880X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710881X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710886X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710887X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710888X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710890X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710891X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710895X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710896X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710897X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710899X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710900X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1710901X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1710902X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1710903X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1710904X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1710905X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710906X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710907X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710908X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710909X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710910X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710911X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710912X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710918X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710921X
         1 "1 YES"
         2 "2 NO" ;

label define H1710922X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1710923X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1710924X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1710925X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710938X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1710939X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1710940X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1710941X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1710942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710948X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710949X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710950X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710951X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710952X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710953X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710954X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1710955X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710956X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710958X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710959X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710960X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710961X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710962X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710963X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710964X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710965X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710966X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710967X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1710968X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1710969X
         -1 "-1 INAPPLICABLE"
         1 "1 HISPANIC"
         2 "2 NON-HISPANIC WHITE ONLY"
         3 "3 NON-HISPANIC BLACK ONLY"
         4 "4 NON-HISPANIC ASIAN ONLY"
         5 "5 NON-HISPANIC OTHER RACE OR MULTIPLE RACE" ;

label define H1710970X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1710971X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         10 "10 OTH ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         12 "12 MULTIPLE RACES REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN INDIAN - NO OTHER RACE REPORTED"
         5 "5 CHINESE - NO OTHER RACE REPORTED"
         6 "6 FILIPINO - NO OTHER RACE REPORTED" ;

label define H1710972X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1710973X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1710974X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1710975X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710976X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1710977X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1710978X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1710979X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1710980X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1710981X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1710982X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1710983X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1710984X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1710985X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1710986X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1710987X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1710988X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1710989X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710990X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710991X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1710992X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1710993X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1710994X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1710995X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1710996X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710997X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710998X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1710999X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1711000X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1711001X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1711002X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1711003X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1711004X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1711005X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1711006X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1711007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711008X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1711009X
         0 "0 NOT ELIGIBLE FOR SAQ"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1711010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1711011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1711014X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711015X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711016X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1711018X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711020X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711021X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1711023X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1711024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1711025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1711026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1711027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711028X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711029X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711030X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711031X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711032X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711035X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1711036X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1711037X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1711038X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H1711039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1711040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1711041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1711042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1711043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1711044X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1711045X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1711046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1711047X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1711048X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1711049X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711050X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711051X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711052X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711053X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711054X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711055X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711056X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711057X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711058X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711059X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711060X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711061X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1711066X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1711067X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1711068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1711069X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1711070X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1711071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1711072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1711073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1711075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1711076X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711077X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711078X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711079X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1711081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1711083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1711084X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1711085X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1711086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1711088X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1711090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711091X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711092X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711093X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711094X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711097X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711098X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711099X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711100X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711101X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711103X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711105X
         1 "1 YES"
         2 "2 NO" ;

label define H1711106X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711107X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711108X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711110X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711111X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711112X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711113X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711114X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711115X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711116X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711117X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711118X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711119X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711120X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711121X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711122X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711123X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711124X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711125X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711126X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1711127X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1711128X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1711129X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711130X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711131X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1711132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1711133X
         1 "1 YES"
         2 "2 NO" ;

label define H1711134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711135X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711136X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711137X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711138X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711139X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1711140X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711141X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1711142X
         0 "0.00"
         75 "$1 - $75" ;

label define H1711143X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1711144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711158X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1711159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1711171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1711173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1711174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1711179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1711180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1711181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 NO HEALTH INSURANCE"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         24 "24 INSURANCE-RELATED REASONS"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H1711182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 YR., LESS THAN 5 YRS."
         3 "3 5 YRS., LESS THAN 10 YRS."
         4 "4 10 YRS., LESS THAN 15 YRS."
         5 "5 15 YEARS OR MORE" ;

label define H1711183X
         0 "0.00"
         96 "$1 - $96" ;

label define H1711184X
         0 "0.00"
         3 "$1 - $3" ;

label define H1711185X
         0 "0.00"
         569 "$1 - $569" ;

label define H1711186X
         0 "0.00"
         445 "$1 - $445" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1710001X;
label value ACTDTY31 H1710002X;
label value ACTDTY42 H1710003X;
label value ACTDTY53 H1710004X;
label value ACTLIM31 H1710005X;
label value ACTLIM53 H1710006X;
label value ADAPPT42 H1710007X;
label value ADCAPE42 H1710008X;
label value ADCLIM42 H1710009X;
label value ADCMPM42 H1710010X;
label value ADCMPY42 H1710011X;
label value ADDAYA42 H1710012X;
label value ADDOWN42 H1710013X;
label value ADDPRS42 H1710014X;
label value ADDRBP42 H1710015X;
label value ADEFRT42 H1710016X;
label value ADEGMC42 H1710017X;
label value ADESSP42 H1710018X;
label value ADEXPL42 H1710019X;
label value ADEZUN42 H1710020X;
label value ADFFRM42 H1710021X;
label value ADFHLP42 H1710022X;
label value ADGENH42 H1710023X;
label value ADHDADDX H1710024X;
label value ADHDAGED H1710025X;
label value ADHECR42 H1710026X;
label value ADHOPE42 H1710027X;
label value ADILCR42 H1710028X;
label value ADILWW42 H1710029X;
label value ADINSA42 H1710030X;
label value ADINSB42 H1710031X;
label value ADINST42 H1710032X;
label value ADINTR42 H1710033X;
label value ADLANG42 H1710034X;
label value ADLHLP31 H1710035X;
label value ADLHLP53 H1710036X;
label value ADLIST42 H1710037X;
label value ADMALS42 H1710038X;
label value ADMWLM42 H1710039X;
label value ADNDCR42 H1710040X;
label value ADNERV42 H1710041X;
label value ADNRGY42 H1710042X;
label value ADNSMK42 H1710043X;
label value ADOVER42 H1710044X;
label value ADPAIN42 H1710045X;
label value ADPALS42 H1710046X;
label value ADPRTM42 H1710047X;
label value ADPRX42 H1710048X;
label value ADPWLM42 H1710049X;
label value ADRESP42 H1710050X;
label value ADREST42 H1710051X;
label value ADRISK42 H1710052X;
label value ADRTCR42 H1710053X;
label value ADRTWW42 H1710054X;
label value ADSAD42 H1710055X;
label value ADSMOK42 H1710056X;
label value ADSOCA42 H1710057X;
label value ADSPEC42 H1710058X;
label value ADTLHW42 H1710059X;
label value ADUPRO42 H1710060X;
label value ADWRTH42 H1710061X;
label value AFDC14 H1710062X;
label value AFTHOU42 H1710063X;
label value AIDHLP31 H1710064X;
label value AIDHLP53 H1710065X;
label value ALIIMP14 H1710066X;
label value AMEWCP14 H1710067X;
label value ANGIAGED H1710068X;
label value ANGIDX H1710069X;
label value ANYLMT14 H1710070X;
label value ARTHAGED H1710071X;
label value ARTHDX H1710072X;
label value ARTHTYPE H1710073X;
label value ASACUT53 H1710074X;
label value ASATAK31 H1710075X;
label value ASATAK53 H1710076X;
label value ASDALY53 H1710077X;
label value ASEVFL53 H1710078X;
label value ASIANP42 H1710079X;
label value ASMRCN53 H1710080X;
label value ASPKFL53 H1710081X;
label value ASPREV53 H1710082X;
label value ASPRIN53 H1710083X;
label value ASSTIL31 H1710084X;
label value ASSTIL53 H1710085X;
label value ASTHAGED H1710086X;
label value ASTHDX H1710087X;
label value ASTHEP31 H1710088X;
label value ASTHEP53 H1710089X;
label value ASWNFL53 H1710090X;
label value BEGRFM31 H1710091X;
label value BEGRFM42 H1710092X;
label value BEGRFM53 H1710093X;
label value BEGRFY31 H1710094X;
label value BEGRFY42 H1710095X;
label value BEGRFY53 H1710096X;
label value BENDIF31 H1710097X;
label value BENDIF53 H1710098X;
label value BLCKPR42 H1710099X;
label value BLIND42 H1710100X;
label value BMINDX53 H1710101X;
label value BOOST42 H1710102X;
label value BORNUSA H1710103X;
label value BPCHEK53 H1710104X;
label value BPMLDX H1710105X;
label value BRSTEX53 H1710106X;
label value BSNTY31 H1710107X;
label value BSNTY31H H1710108X;
label value BSNTY42 H1710109X;
label value BSNTY42H H1710110X;
label value BSNTY53 H1710111X;
label value BSNTY53H H1710112X;
label value BSTSRE53 H1710113X;
label value BSTST53 H1710114X;
label value BUSIMP14 H1710115X;
label value CABLADDR H1710116X;
label value CABREAST H1710117X;
label value CACERVIX H1710118X;
label value CACOLON H1710119X;
label value CALUNG H1710120X;
label value CALYMPH H1710121X;
label value CAMELANO H1710122X;
label value CANCERDX H1710123X;
label value CAOTHER H1710124X;
label value CAPROSTA H1710125X;
label value CARECO42 H1710126X;
label value CASKINDK H1710127X;
label value CASKINNM H1710128X;
label value CAUTERUS H1710129X;
label value CHAPPT42 H1710130X;
label value CHBMIX42 H1710131X;
label value CHBRON31 H1710132X;
label value CHBRON53 H1710133X;
label value CHCOUN42 H1710134X;
label value CHDAGED H1710135X;
label value CHDDX H1710136X;
label value CHECK53 H1710137X;
label value CHEMPB42 H1710138X;
label value CHENEC42 H1710139X;
label value CHEXPL42 H1710140X;
label value CHEYRE42 H1710141X;
label value CHGJ3142 H1710142X;
label value CHGJ4253 H1710143X;
label value CHHECR42 H1710144X;
label value CHILCR42 H1710145X;
label value CHILWW42 H1710146X;
label value CHLICO42 H1710147X;
label value CHLIHB42 H1710148X;
label value CHLIMI42 H1710149X;
label value CHLIMP14 H1710150X;
label value CHLIST42 H1710151X;
label value CHNDCR42 H1710152X;
label value CHOIC31 H1710153X;
label value CHOIC42 H1710154X;
label value CHOIC53 H1710155X;
label value CHOLAGED H1710156X;
label value CHOLCK53 H1710157X;
label value CHOLDX H1710158X;
label value CHPMCN42 H1710159X;
label value CHPMED42 H1710160X;
label value CHPMHB42 H1710161X;
label value CHPRTM42 H1710162X;
label value CHRESP42 H1710163X;
label value CHRTCR42 H1710164X;
label value CHRTWW42 H1710165X;
label value CHSERV42 H1710166X;
label value CHSPEC42 H1710167X;
label value CHSRCN42 H1710168X;
label value CHSRHB42 H1710169X;
label value CHTHCO42 H1710170X;
label value CHTHER42 H1710171X;
label value CHTHHB42 H1710172X;
label value CLINIC42 H1710173X;
label value CLMDEP14 H1710174X;
label value CLMHIP14 H1710175X;
label value CLNTRE53 H1710176X;
label value CLNTST53 H1710177X;
label value CMJHLD31 H1710178X;
label value CMJHLD42 H1710179X;
label value CMJHLD53 H1710180X;
label value COGLIM31 H1710181X;
label value COGLIM53 H1710182X;
label value COVRMM H1710183X;
label value COVRYY H1710184X;
label value CRFMPY42 H1710185X;
label value CSHCN42 H1710186X;
label value CSHIMP14 H1710187X;
label value DADPRO42 H1710188X;
label value DDNSCL31 H1710189X;
label value DDNSCL42 H1710190X;
label value DDNSCL53 H1710191X;
label value DDNWRK31 H1710192X;
label value DDNWRK42 H1710193X;
label value DDNWRK53 H1710194X;
label value DEAF42 H1710195X;
label value DECIDE42 H1710196X;
label value DENTAL42 H1710197X;
label value DENTCK53 H1710198X;
label value DENTIN31 H1710199X;
label value DENTIN42 H1710200X;
label value DENTIN53 H1710201X;
label value DEPDNT14 H1710202X;
label value DFCOG42 H1710203X;
label value DFDRSB42 H1710204X;
label value DFERND42 H1710205X;
label value DFHEAR42 H1710206X;
label value DFSEE42 H1710207X;
label value DFWLKC42 H1710208X;
label value DIABAGED H1710209X;
label value DIABDX H1710210X;
label value DIFFPL42 H1710211X;
label value DIFFWG31 H1710212X;
label value DIFFWG42 H1710213X;
label value DIFFWG53 H1710214X;
label value DISVW31X H1710215X;
label value DISVW42X H1710216X;
label value DISVW53X H1710217X;
label value DIVIMP14 H1710218X;
label value DKWHRU42 H1710219X;
label value DNDLAY42 H1710220X;
label value DNDLRS42 H1710221X;
label value DNTINS14 H1710222X;
label value DNTINS31 H1710223X;
label value DNUNAB42 H1710224X;
label value DNUNRS42 H1710225X;
label value DOBMM H1710226X;
label value DOBYY H1710227X;
label value DOCELS42 H1710228X;
label value DPINRU14 H1710229X;
label value DPOTSD14 H1710230X;
label value DSA1C53 H1710231X;
label value DSCB1353 H1710232X;
label value DSCGRP53 H1710233X;
label value DSCH1353 H1710234X;
label value DSCH1453 H1710235X;
label value DSCH1553 H1710236X;
label value DSCHNV53 H1710237X;
label value DSCINT53 H1710238X;
label value DSCNPC53 H1710239X;
label value DSCONF53 H1710240X;
label value DSCPCP53 H1710241X;
label value DSCPHN53 H1710242X;
label value DSDIA53 H1710243X;
label value DSDIET53 H1710244X;
label value DSEB1353 H1710245X;
label value DSEY1353 H1710246X;
label value DSEY1453 H1710247X;
label value DSEY1553 H1710248X;
label value DSEYNV53 H1710249X;
label value DSEYPR53 H1710250X;
label value DSFB1353 H1710251X;
label value DSFL1353 H1710252X;
label value DSFL1453 H1710253X;
label value DSFL1553 H1710254X;
label value DSFLNV53 H1710255X;
label value DSFT1353 H1710256X;
label value DSFT1453 H1710257X;
label value DSFT1553 H1710258X;
label value DSFTNV53 H1710259X;
label value DSINSU53 H1710260X;
label value DSKIDN53 H1710261X;
label value DSMED53 H1710262X;
label value DSPRX53 H1710263X;
label value DSVB1353 H1710264X;
label value DVGEN14 H1710265X;
label value DVOOSR14 H1710266X;
label value DVORTH14 H1710267X;
label value DVOVA14 H1710268X;
label value DVTOT14 H1710269X;
label value EATHLT42 H1710270X;
label value EDRECODE H1710271X;
label value EDUCYR H1710272X;
label value EDUYRDG H1710273X;
label value EICRDT14 H1710274X;
label value ELGRND14 H1710275X;
label value ELGRND31 H1710276X;
label value ELGRND42 H1710277X;
label value ELGRND53 H1710278X;
label value EMPHAGED H1710279X;
label value EMPHDX H1710280X;
label value EMPST31 H1710281X;
label value EMPST31H H1710282X;
label value EMPST42 H1710283X;
label value EMPST42H H1710284X;
label value EMPST53 H1710285X;
label value EMPST53H H1710286X;
label value ENDRFM14 H1710287X;
label value ENDRFM31 H1710288X;
label value ENDRFM42 H1710289X;
label value ENDRFM53 H1710290X;
label value ENDRFY14 H1710291X;
label value ENDRFY31 H1710292X;
label value ENDRFY42 H1710293X;
label value ENDRFY53 H1710294X;
label value ERDOFD14 H1710295X;
label value ERTOT14 H1710296X;
label value EVRETIRE H1710297X;
label value EVRWRK H1710298X;
label value EXPLOP42 H1710299X;
label value EXRCIS53 H1710300X;
label value FAMRFPYR H1710301X;
label value FAMSZE31 H1710302X;
label value FAMSZE42 H1710303X;
label value FAMSZE53 H1710304X;
label value FCRP1231 H1710305X;
label value FILEDR14 H1710306X;
label value FILER14 H1710307X;
label value FLSTAT14 H1710308X;
label value FLUSHT53 H1710309X;
label value FMRS1231 H1710310X;
label value FNGRDF31 H1710311X;
label value FNGRDF53 H1710312X;
label value FOODMN14 H1710313X;
label value FOODST14 H1710314X;
label value FOODVL14 H1710315X;
label value FSAAMT31 H1710316X;
label value FSAGT31 H1710317X;
label value FTSTU14X H1710318X;
label value FTSTU31X H1710319X;
label value FTSTU42X H1710320X;
label value FTSTU53X H1710321X;
label value GENDRP42 H1710322X;
label value HASFSA31 H1710323X;
label value HAVEUS42 H1710324X;
label value HAVFUN42 H1710325X;
label value HEALTH42 H1710326X;
label value HEARAD42 H1710327X;
label value HELD31X H1710328X;
label value HELD42X H1710329X;
label value HELD53X H1710330X;
label value HELMET42 H1710331X;
label value HHAGD14 H1710332X;
label value HHATRI14 H1710333X;
label value HHAWCP14 H1710334X;
label value HHINDD14 H1710335X;
label value HHINFD14 H1710336X;
label value HHNOSR14 H1710337X;
label value HHNSTL14 H1710338X;
label value HHNVA14 H1710339X;
label value HHNWCP14 H1710340X;
label value HHTOTD14 H1710341X;
label value HIBPAGED H1710342X;
label value HIBPDX H1710343X;
label value HISPANX H1710344X;
label value HISPNCAT H1710345X;
label value HOMEBH42 H1710346X;
label value HONRDC31 H1710347X;
label value HONRDC42 H1710348X;
label value HONRDC53 H1710349X;
label value HOUR31 H1710350X;
label value HOUR42 H1710351X;
label value HOUR53 H1710352X;
label value HPDAP14 H1710353X;
label value HPDAU14 H1710354X;
label value HPDDE14 H1710355X;
label value HPDFE14 H1710356X;
label value HPDJA14 H1710357X;
label value HPDJL14 H1710358X;
label value HPDJU14 H1710359X;
label value HPDMA14 H1710360X;
label value HPDMY14 H1710361X;
label value HPDNO14 H1710362X;
label value HPDOC14 H1710363X;
label value HPDSE14 H1710364X;
label value HPEAP14 H1710365X;
label value HPEAU14 H1710366X;
label value HPEDE14 H1710367X;
label value HPEFE14 H1710368X;
label value HPEJA14 H1710369X;
label value HPEJL14 H1710370X;
label value HPEJU14 H1710371X;
label value HPEMA14 H1710372X;
label value HPEMY14 H1710373X;
label value HPENO14 H1710374X;
label value HPEOC14 H1710375X;
label value HPESE14 H1710376X;
label value HPNAP14 H1710377X;
label value HPNAU14 H1710378X;
label value HPNDE14 H1710379X;
label value HPNFE14 H1710380X;
label value HPNJA14 H1710381X;
label value HPNJL14 H1710382X;
label value HPNJU14 H1710383X;
label value HPNMA14 H1710384X;
label value HPNMY14 H1710385X;
label value HPNNO14 H1710386X;
label value HPNOC14 H1710387X;
label value HPNSE14 H1710388X;
label value HPOAP14 H1710389X;
label value HPOAU14 H1710390X;
label value HPODE14 H1710391X;
label value HPOFE14 H1710392X;
label value HPOJA14 H1710393X;
label value HPOJL14 H1710394X;
label value HPOJU14 H1710395X;
label value HPOMA14 H1710396X;
label value HPOMY14 H1710397X;
label value HPONO14 H1710398X;
label value HPOOC14 H1710399X;
label value HPOSE14 H1710400X;
label value HPRAP14 H1710401X;
label value HPRAU14 H1710402X;
label value HPRDE14 H1710403X;
label value HPRFE14 H1710404X;
label value HPRJA14 H1710405X;
label value HPRJL14 H1710406X;
label value HPRJU14 H1710407X;
label value HPRMA14 H1710408X;
label value HPRMY14 H1710409X;
label value HPRNO14 H1710410X;
label value HPROC14 H1710411X;
label value HPRSE14 H1710412X;
label value HPSAP14 H1710413X;
label value HPSAU14 H1710414X;
label value HPSDE14 H1710415X;
label value HPSFE14 H1710416X;
label value HPSJA14 H1710417X;
label value HPSJL14 H1710418X;
label value HPSJU14 H1710419X;
label value HPSMA14 H1710420X;
label value HPSMY14 H1710421X;
label value HPSNO14 H1710422X;
label value HPSOC14 H1710423X;
label value HPSSE14 H1710424X;
label value HPXAP14 H1710425X;
label value HPXAU14 H1710426X;
label value HPXDE14 H1710427X;
label value HPXFE14 H1710428X;
label value HPXJA14 H1710429X;
label value HPXJL14 H1710430X;
label value HPXJU14 H1710431X;
label value HPXMA14 H1710432X;
label value HPXMY14 H1710433X;
label value HPXNO14 H1710434X;
label value HPXOC14 H1710435X;
label value HPXSE14 H1710436X;
label value HRHOW31 H1710437X;
label value HRHOW42 H1710438X;
label value HRHOW53 H1710439X;
label value HRWG31H H1710440X;
label value HRWG31X H1710441X;
label value HRWG42H H1710442X;
label value HRWG42X H1710443X;
label value HRWG53H H1710444X;
label value HRWG53X H1710445X;
label value HRWGIM31 H1710446X;
label value HRWGIM42 H1710447X;
label value HRWGIM53 H1710448X;
label value HSELIM31 H1710449X;
label value HSELIM53 H1710450X;
label value HSPLAP42 H1710451X;
label value HWELLSPE H1710452X;
label value HYSTER53 H1710453X;
label value IADLHP31 H1710454X;
label value IADLHP53 H1710455X;
label value INDCAT31 H1710456X;
label value INDCAT42 H1710457X;
label value INDCAT53 H1710458X;
label value INDCT31H H1710459X;
label value INDCT42H H1710460X;
label value INDCT53H H1710461X;
label value INS14X H1710462X;
label value INS31X H1710463X;
label value INS42X H1710464X;
label value INS53X H1710465X;
label value INSAP14X H1710466X;
label value INSAT14X H1710467X;
label value INSAT31X H1710468X;
label value INSAT42X H1710469X;
label value INSAT53X H1710470X;
label value INSAU14X H1710471X;
label value INSC1231 H1710472X;
label value INSCOP14 H1710473X;
label value INSCOP31 H1710474X;
label value INSCOP42 H1710475X;
label value INSCOP53 H1710476X;
label value INSCOPE H1710477X;
label value INSCOV14 H1710478X;
label value INSDE14X H1710479X;
label value INSENDMM H1710480X;
label value INSENDYY H1710481X;
label value INSFE14X H1710482X;
label value INSJA14X H1710483X;
label value INSJL14X H1710484X;
label value INSJU14X H1710485X;
label value INSMA14X H1710486X;
label value INSMY14X H1710487X;
label value INSNO14X H1710488X;
label value INSOC14X H1710489X;
label value INSRPL42 H1710490X;
label value INSSE14X H1710491X;
label value INSURC14 H1710492X;
label value INTIMP14 H1710493X;
label value INTVLANG H1710494X;
label value IPDIS14 H1710495X;
label value IPDOFD14 H1710496X;
label value IPZERO14 H1710497X;
label value IRAIMP14 H1710498X;
label value JBORG31H H1710499X;
label value JBORG42H H1710500X;
label value JBORG53H H1710501X;
label value JNTPID14 H1710502X;
label value JOBORG31 H1710503X;
label value JOBORG42 H1710504X;
label value JOBORG53 H1710505X;
label value JOBRSN42 H1710506X;
label value JTINRU14 H1710507X;
label value JTPAIN31 H1710508X;
label value JTPAIN53 H1710509X;
label value K6SUM42 H1710510X;
label value KEYNESS H1710511X;
label value KIDPRO42 H1710512X;
label value KNOWDR42 H1710513X;
label value LANGSPK H1710514X;
label value LAPBLT42 H1710515X;
label value LFTDIF31 H1710516X;
label value LFTDIF53 H1710517X;
label value LOCATN42 H1710518X;
label value LSTETH53 H1710519X;
label value MAMOGR53 H1710520X;
label value MARRY14X H1710521X;
label value MARRY31X H1710522X;
label value MARRY42X H1710523X;
label value MARRY53X H1710524X;
label value MCAID14 H1710525X;
label value MCAID14X H1710526X;
label value MCAID31 H1710527X;
label value MCAID31X H1710528X;
label value MCAID42 H1710529X;
label value MCAID42X H1710530X;
label value MCAID53 H1710531X;
label value MCAID53X H1710532X;
label value MCARE14 H1710533X;
label value MCARE14X H1710534X;
label value MCARE31 H1710535X;
label value MCARE31X H1710536X;
label value MCARE42 H1710537X;
label value MCARE42X H1710538X;
label value MCARE53 H1710539X;
label value MCARE53X H1710540X;
label value MCDAP14 H1710541X;
label value MCDAP14X H1710542X;
label value MCDAT14X H1710543X;
label value MCDAT31X H1710544X;
label value MCDAT42X H1710545X;
label value MCDAT53X H1710546X;
label value MCDAU14 H1710547X;
label value MCDAU14X H1710548X;
label value MCDDE14 H1710549X;
label value MCDDE14X H1710550X;
label value MCDEV14 H1710551X;
label value MCDFE14 H1710552X;
label value MCDFE14X H1710553X;
label value MCDHMO14 H1710554X;
label value MCDHMO31 H1710555X;
label value MCDHMO42 H1710556X;
label value MCDJA14 H1710557X;
label value MCDJA14X H1710558X;
label value MCDJL14 H1710559X;
label value MCDJL14X H1710560X;
label value MCDJU14 H1710561X;
label value MCDJU14X H1710562X;
label value MCDMA14 H1710563X;
label value MCDMA14X H1710564X;
label value MCDMC14 H1710565X;
label value MCDMC31 H1710566X;
label value MCDMC42 H1710567X;
label value MCDMY14 H1710568X;
label value MCDMY14X H1710569X;
label value MCDNO14 H1710570X;
label value MCDNO14X H1710571X;
label value MCDOC14 H1710572X;
label value MCDOC14X H1710573X;
label value MCDSE14 H1710574X;
label value MCDSE14X H1710575X;
label value MCRAP14 H1710576X;
label value MCRAP14X H1710577X;
label value MCRAU14 H1710578X;
label value MCRAU14X H1710579X;
label value MCRDE14 H1710580X;
label value MCRDE14X H1710581X;
label value MCREV14 H1710582X;
label value MCRFE14 H1710583X;
label value MCRFE14X H1710584X;
label value MCRJA14 H1710585X;
label value MCRJA14X H1710586X;
label value MCRJL14 H1710587X;
label value MCRJL14X H1710588X;
label value MCRJU14 H1710589X;
label value MCRJU14X H1710590X;
label value MCRMA14 H1710591X;
label value MCRMA14X H1710592X;
label value MCRMY14 H1710593X;
label value MCRMY14X H1710594X;
label value MCRNO14 H1710595X;
label value MCRNO14X H1710596X;
label value MCROC14 H1710597X;
label value MCROC14X H1710598X;
label value MCRPB14 H1710599X;
label value MCRPB31 H1710600X;
label value MCRPB42 H1710601X;
label value MCRPD14 H1710602X;
label value MCRPD14X H1710603X;
label value MCRPD31 H1710604X;
label value MCRPD31X H1710605X;
label value MCRPD42 H1710606X;
label value MCRPD42X H1710607X;
label value MCRPHO14 H1710608X;
label value MCRPHO31 H1710609X;
label value MCRPHO42 H1710610X;
label value MCRSE14 H1710611X;
label value MCRSE14X H1710612X;
label value MDDLAY42 H1710613X;
label value MDDLRS42 H1710614X;
label value MDUNAB42 H1710615X;
label value MDUNRS42 H1710616X;
label value MESBPR42 H1710617X;
label value MESHGT42 H1710618X;
label value MESVIS42 H1710619X;
label value MESWGT42 H1710620X;
label value MIAGED H1710621X;
label value MIDX H1710622X;
label value MILDIF31 H1710623X;
label value MILDIF53 H1710624X;
label value MINORP42 H1710625X;
label value MNHLTH31 H1710626X;
label value MNHLTH42 H1710627X;
label value MNHLTH53 H1710628X;
label value MOMPRO42 H1710629X;
label value MORE31 H1710630X;
label value MORE31H H1710631X;
label value MORE42 H1710632X;
label value MORE42H H1710633X;
label value MORE53 H1710634X;
label value MORE53H H1710635X;
label value MORECOVR H1710636X;
label value MORJOB31 H1710637X;
label value MORJOB42 H1710638X;
label value MORJOB53 H1710639X;
label value MYSELF42 H1710640X;
label value NATAMP42 H1710641X;
label value NERVAF42 H1710642X;
label value NEWARE42 H1710643X;
label value NEWDOC42 H1710644X;
label value NHRWG31 H1710645X;
label value NHRWG42 H1710646X;
label value NHRWG53 H1710647X;
label value NOASPR53 H1710648X;
label value NOFAT53 H1710649X;
label value NOGODR42 H1710650X;
label value NOHINS42 H1710651X;
label value NOINSBEF H1710652X;
label value NOINSTM H1710653X;
label value NOINUNIT H1710654X;
label value NOLIKE42 H1710655X;
label value NOREAS42 H1710656X;
label value NOSMOK42 H1710657X;
label value NUMEMP31 H1710658X;
label value NUMEMP42 H1710659X;
label value NUMEMP53 H1710660X;
label value NWK31 H1710661X;
label value NWK42 H1710662X;
label value NWK53 H1710663X;
label value OBASST14 H1710664X;
label value OBCHIR14 H1710665X;
label value OBDRV14 H1710666X;
label value OBEWCP14 H1710667X;
label value OBNURS14 H1710668X;
label value OBOPTO14 H1710669X;
label value OBOTHV14 H1710670X;
label value OBTHER14 H1710671X;
label value OBTOTV14 H1710672X;
label value OCCCAT31 H1710673X;
label value OCCCAT42 H1710674X;
label value OCCCAT53 H1710675X;
label value OCCCT31H H1710676X;
label value OCCCT42H H1710677X;
label value OCCCT53H H1710678X;
label value OFEMP31H H1710679X;
label value OFEMP42H H1710680X;
label value OFEMP53H H1710681X;
label value OFFER31H H1710682X;
label value OFFER31X H1710683X;
label value OFFER42H H1710684X;
label value OFFER42X H1710685X;
label value OFFER53H H1710686X;
label value OFFER53X H1710687X;
label value OFFHOU42 H1710688X;
label value OFREMP31 H1710689X;
label value OFREMP42 H1710690X;
label value OFREMP53 H1710691X;
label value OHRTAGED H1710692X;
label value OHRTDX H1710693X;
label value ONGONG42 H1710694X;
label value ONJOB42 H1710695X;
label value OPAAP14 H1710696X;
label value OPAAU14 H1710697X;
label value OPADE14 H1710698X;
label value OPAEV14 H1710699X;
label value OPAFE14 H1710700X;
label value OPAJA14 H1710701X;
label value OPAJL14 H1710702X;
label value OPAJU14 H1710703X;
label value OPAMA14 H1710704X;
label value OPAMY14 H1710705X;
label value OPANO14 H1710706X;
label value OPAOC14 H1710707X;
label value OPASE14 H1710708X;
label value OPBAP14 H1710709X;
label value OPBAU14 H1710710X;
label value OPBDE14 H1710711X;
label value OPBEV14 H1710712X;
label value OPBFE14 H1710713X;
label value OPBJA14 H1710714X;
label value OPBJL14 H1710715X;
label value OPBJU14 H1710716X;
label value OPBMA14 H1710717X;
label value OPBMY14 H1710718X;
label value OPBNO14 H1710719X;
label value OPBOC14 H1710720X;
label value OPBSE14 H1710721X;
label value OPDOFD14 H1710722X;
label value OPDRV14 H1710723X;
label value OPOTHV14 H1710724X;
label value OPSOFD14 H1710725X;
label value OPTOTV14 H1710726X;
label value OTHDYS31 H1710727X;
label value OTHDYS42 H1710728X;
label value OTHDYS53 H1710729X;
label value OTHIMP14 H1710730X;
label value OTHINS42 H1710731X;
label value OTHLANG H1710732X;
label value OTHNDD31 H1710733X;
label value OTHNDD42 H1710734X;
label value OTHNDD53 H1710735X;
label value OTHOFD14 H1710736X;
label value OTHRCP42 H1710737X;
label value OTHREA42 H1710738X;
label value OTPAAT14 H1710739X;
label value OTPAAT31 H1710740X;
label value OTPAAT42 H1710741X;
label value OTPAAT53 H1710742X;
label value OTPBAT14 H1710743X;
label value OTPBAT31 H1710744X;
label value OTPBAT42 H1710745X;
label value OTPBAT53 H1710746X;
label value OTPUBA14 H1710747X;
label value OTPUBA31 H1710748X;
label value OTPUBA42 H1710749X;
label value OTPUBA53 H1710750X;
label value OTPUBB14 H1710751X;
label value OTPUBB31 H1710752X;
label value OTPUBB42 H1710753X;
label value OTPUBB53 H1710754X;
label value PACISP42 H1710755X;
label value PANEL H1710756X;
label value PAPSMR53 H1710757X;
label value PAYDR31 H1710758X;
label value PAYDR31H H1710759X;
label value PAYDR42 H1710760X;
label value PAYDR42H H1710761X;
label value PAYDR53 H1710762X;
label value PAYDR53H H1710763X;
label value PAYVAC31 H1710764X;
label value PAYVAC42 H1710765X;
label value PAYVAC53 H1710766X;
label value PDKAP14 H1710767X;
label value PDKAU14 H1710768X;
label value PDKDE14 H1710769X;
label value PDKFE14 H1710770X;
label value PDKJA14 H1710771X;
label value PDKJL14 H1710772X;
label value PDKJU14 H1710773X;
label value PDKMA14 H1710774X;
label value PDKMY14 H1710775X;
label value PDKNO14 H1710776X;
label value PDKOC14 H1710777X;
label value PDKSE14 H1710778X;
label value PEGAP14 H1710779X;
label value PEGAU14 H1710780X;
label value PEGDE14 H1710781X;
label value PEGFE14 H1710782X;
label value PEGJA14 H1710783X;
label value PEGJL14 H1710784X;
label value PEGJU14 H1710785X;
label value PEGMA14 H1710786X;
label value PEGMY14 H1710787X;
label value PEGNO14 H1710788X;
label value PEGOC14 H1710789X;
label value PEGSE14 H1710790X;
label value PENIMP14 H1710791X;
label value PERSLA42 H1710792X;
label value PHNREG42 H1710793X;
label value PHQ242 H1710794X;
label value PHYEXE53 H1710795X;
label value PHYSCL42 H1710796X;
label value PLCTYP42 H1710797X;
label value PMDINS14 H1710798X;
label value PMDINS31 H1710799X;
label value PMDLAY42 H1710800X;
label value PMDLRS42 H1710801X;
label value PMEDIN31 H1710802X;
label value PMEDIN42 H1710803X;
label value PMEDIN53 H1710804X;
label value PMEDPY31 H1710805X;
label value PMEDPY42 H1710806X;
label value PMEDPY53 H1710807X;
label value PMEDUP31 H1710808X;
label value PMEDUP42 H1710809X;
label value PMEDUP53 H1710810X;
label value PMUNAB42 H1710811X;
label value PMUNRS42 H1710812X;
label value PNGAP14 H1710813X;
label value PNGAU14 H1710814X;
label value PNGDE14 H1710815X;
label value PNGFE14 H1710816X;
label value PNGJA14 H1710817X;
label value PNGJL14 H1710818X;
label value PNGJU14 H1710819X;
label value PNGMA14 H1710820X;
label value PNGMY14 H1710821X;
label value PNGNO14 H1710822X;
label value PNGOC14 H1710823X;
label value PNGSE14 H1710824X;
label value POGAP14 H1710825X;
label value POGAU14 H1710826X;
label value POGDE14 H1710827X;
label value POGFE14 H1710828X;
label value POGJA14 H1710829X;
label value POGJL14 H1710830X;
label value POGJU14 H1710831X;
label value POGMA14 H1710832X;
label value POGMY14 H1710833X;
label value POGNO14 H1710834X;
label value POGOC14 H1710835X;
label value POGSE14 H1710836X;
label value POUAP14 H1710837X;
label value POUAU14 H1710838X;
label value POUDE14 H1710839X;
label value POUFE14 H1710840X;
label value POUJA14 H1710841X;
label value POUJL14 H1710842X;
label value POUJU14 H1710843X;
label value POUMA14 H1710844X;
label value POUMY14 H1710845X;
label value POUNO14 H1710846X;
label value POUOC14 H1710847X;
label value POUSE14 H1710848X;
label value POVCAT14 H1710849X;
label value PREGNT31 H1710850X;
label value PREGNT42 H1710851X;
label value PREGNT53 H1710852X;
label value PREVCOVR H1710853X;
label value PREVEN42 H1710854X;
label value PRIAP14 H1710855X;
label value PRIAU14 H1710856X;
label value PRIDE14 H1710857X;
label value PRIDK14 H1710858X;
label value PRIDK31 H1710859X;
label value PRIDK42 H1710860X;
label value PRIDK53 H1710861X;
label value PRIEU14 H1710862X;
label value PRIEU31 H1710863X;
label value PRIEU42 H1710864X;
label value PRIEU53 H1710865X;
label value PRIFE14 H1710866X;
label value PRIJA14 H1710867X;
label value PRIJL14 H1710868X;
label value PRIJU14 H1710869X;
label value PRIMA14 H1710870X;
label value PRIMY14 H1710871X;
label value PRING14 H1710872X;
label value PRING31 H1710873X;
label value PRING42 H1710874X;
label value PRING53 H1710875X;
label value PRINO14 H1710876X;
label value PRIOC14 H1710877X;
label value PRIOG14 H1710878X;
label value PRIOG31 H1710879X;
label value PRIOG42 H1710880X;
label value PRIOG53 H1710881X;
label value PRIS14 H1710882X;
label value PRIS31 H1710883X;
label value PRIS42 H1710884X;
label value PRIS53 H1710885X;
label value PRISE14 H1710886X;
label value PRIV14 H1710887X;
label value PRIV31 H1710888X;
label value PRIV42 H1710889X;
label value PRIV53 H1710890X;
label value PRIVAT14 H1710891X;
label value PRIVAT31 H1710892X;
label value PRIVAT42 H1710893X;
label value PRIVAT53 H1710894X;
label value PROBPY42 H1710895X;
label value PROUT14 H1710896X;
label value PROUT31 H1710897X;
label value PROUT42 H1710898X;
label value PROUT53 H1710899X;
label value PROVTY42 H1710900X;
label value PROXY14 H1710901X;
label value PROXY31 H1710902X;
label value PROXY42 H1710903X;
label value PROXY53 H1710904X;
label value PRSAP14 H1710905X;
label value PRSAU14 H1710906X;
label value PRSDE14 H1710907X;
label value PRSFE14 H1710908X;
label value PRSJA14 H1710909X;
label value PRSJL14 H1710910X;
label value PRSJU14 H1710911X;
label value PRSMA14 H1710912X;
label value PRSMY14 H1710913X;
label value PRSNO14 H1710914X;
label value PRSOC14 H1710915X;
label value PRSSE14 H1710916X;
label value PRSTX14 H1710917X;
label value PRSTX31 H1710918X;
label value PRSTX42 H1710919X;
label value PRSTX53 H1710920X;
label value PRVEV14 H1710921X;
label value PRVHMO14 H1710922X;
label value PRVHMO31 H1710923X;
label value PRVHMO42 H1710924X;
label value PRVSPK42 H1710925X;
label value PRXAP14 H1710926X;
label value PRXAU14 H1710927X;
label value PRXDE14 H1710928X;
label value PRXFE14 H1710929X;
label value PRXJA14 H1710930X;
label value PRXJL14 H1710931X;
label value PRXJU14 H1710932X;
label value PRXMA14 H1710933X;
label value PRXMY14 H1710934X;
label value PRXNO14 H1710935X;
label value PRXOC14 H1710936X;
label value PRXSE14 H1710937X;
label value PSA53 H1710938X;
label value PSTATS31 H1710939X;
label value PSTATS42 H1710940X;
label value PSTATS53 H1710941X;
label value PUB14X H1710942X;
label value PUB31X H1710943X;
label value PUB42X H1710944X;
label value PUB53X H1710945X;
label value PUBAP14X H1710946X;
label value PUBAT14X H1710947X;
label value PUBAT31X H1710948X;
label value PUBAT42X H1710949X;
label value PUBAT53X H1710950X;
label value PUBAU14X H1710951X;
label value PUBDE14X H1710952X;
label value PUBFE14X H1710953X;
label value PUBIMP14 H1710954X;
label value PUBJA14X H1710955X;
label value PUBJL14X H1710956X;
label value PUBJU14X H1710957X;
label value PUBMA14X H1710958X;
label value PUBMY14X H1710959X;
label value PUBNO14X H1710960X;
label value PUBOC14X H1710961X;
label value PUBSE14X H1710962X;
label value PYUNBL42 H1710963X;
label value PYVAC31H H1710964X;
label value PYVAC42H H1710965X;
label value PYVAC53H H1710966X;
label value RACEAX H1710967X;
label value RACEBX H1710968X;
label value RACETHX H1710969X;
label value RACEV1X H1710970X;
label value RACEV2X H1710971X;
label value RACEWX H1710972X;
label value RCHDIF31 H1710973X;
label value RCHDIF53 H1710974X;
label value REFFRL42 H1710975X;
label value REFRL14X H1710976X;
label value REFRL31X H1710977X;
label value REFRL42X H1710978X;
label value REFRL53X H1710979X;
label value REGION14 H1710980X;
label value REGION31 H1710981X;
label value REGION42 H1710982X;
label value REGION53 H1710983X;
label value RESP14 H1710984X;
label value RESP31 H1710985X;
label value RESP42 H1710986X;
label value RESP53 H1710987X;
label value RESPCT42 H1710988X;
label value RETPLN31 H1710989X;
label value RETPLN42 H1710990X;
label value RETPLN53 H1710991X;
label value RNDFLG31 H1710992X;
label value RTHLTH31 H1710993X;
label value RTHLTH42 H1710994X;
label value RTHLTH53 H1710995X;
label value RTPLN31H H1710996X;
label value RTPLN42H H1710997X;
label value RTPLN53H H1710998X;
label value RUCLAS14 H1710999X;
label value RUCLAS31 H1711000X;
label value RUCLAS42 H1711001X;
label value RUCLAS53 H1711002X;
label value RUSIZE14 H1711003X;
label value RUSIZE31 H1711004X;
label value RUSIZE42 H1711005X;
label value RUSIZE53 H1711006X;
label value SAFEST42 H1711007X;
label value SALIMP14 H1711008X;
label value SAQELIG H1711009X;
label value SCHLBH42 H1711010X;
label value SCHLIM31 H1711011X;
label value SCHLIM53 H1711012X;
label value SCHPRO42 H1711013X;
label value SCPAY31H H1711014X;
label value SCPAY42H H1711015X;
label value SCPAY53H H1711016X;
label value SEATBE53 H1711017X;
label value SELDSI42 H1711018X;
label value SELFCM31 H1711019X;
label value SELFCM42 H1711020X;
label value SELFCM53 H1711021X;
label value SEX H1711022X;
label value SFFLAG42 H1711023X;
label value SGMTRE53 H1711024X;
label value SGMTST53 H1711025X;
label value SIBPRO42 H1711026X;
label value SICPAY31 H1711027X;
label value SICPAY42 H1711028X;
label value SICPAY53 H1711029X;
label value SLFCM31H H1711030X;
label value SLFCM42H H1711031X;
label value SLFCM53H H1711032X;
label value SOCLIM31 H1711033X;
label value SOCLIM53 H1711034X;
label value SPOUID14 H1711035X;
label value SPOUID31 H1711036X;
label value SPOUID42 H1711037X;
label value SPOUID53 H1711038X;
label value SPOUIN14 H1711039X;
label value SPOUIN31 H1711040X;
label value SPOUIN42 H1711041X;
label value SPOUIN53 H1711042X;
label value SPRPRO42 H1711043X;
label value SSCIMP14 H1711044X;
label value SSIIMP14 H1711045X;
label value SSNLJB31 H1711046X;
label value SSNLJB42 H1711047X;
label value SSNLJB53 H1711048X;
label value STAAP14 H1711049X;
label value STAAU14 H1711050X;
label value STADE14 H1711051X;
label value STAFE14 H1711052X;
label value STAJA14 H1711053X;
label value STAJL14 H1711054X;
label value STAJU14 H1711055X;
label value STAMA14 H1711056X;
label value STAMY14 H1711057X;
label value STANO14 H1711058X;
label value STAOC14 H1711059X;
label value STAPR14 H1711060X;
label value STAPR31 H1711061X;
label value STAPR42 H1711062X;
label value STAPR53 H1711063X;
label value STASE14 H1711064X;
label value STJBMM31 H1711065X;
label value STJBMM42 H1711066X;
label value STJBMM53 H1711067X;
label value STJBYY31 H1711068X;
label value STJBYY42 H1711069X;
label value STJBYY53 H1711070X;
label value STNDIF31 H1711071X;
label value STNDIF53 H1711072X;
label value STOMCH53 H1711073X;
label value STPDIF31 H1711074X;
label value STPDIF53 H1711075X;
label value STPRAT14 H1711076X;
label value STPRAT31 H1711077X;
label value STPRAT42 H1711078X;
label value STPRAT53 H1711079X;
label value STRKAGED H1711080X;
label value STRKDX H1711081X;
label value TAXFRM14 H1711082X;
label value TEMPJB31 H1711083X;
label value TEMPJB42 H1711084X;
label value TEMPJB53 H1711085X;
label value TIMALN42 H1711086X;
label value TMTKUS42 H1711087X;
label value TRANS42 H1711088X;
label value TRBLE42 H1711089X;
label value TREATM42 H1711090X;
label value TRIAP14X H1711091X;
label value TRIAT14X H1711092X;
label value TRIAT31X H1711093X;
label value TRIAT42X H1711094X;
label value TRIAT53X H1711095X;
label value TRIAU14X H1711096X;
label value TRICH14X H1711097X;
label value TRICH31X H1711098X;
label value TRICH42X H1711099X;
label value TRICR14X H1711100X;
label value TRICR31X H1711101X;
label value TRICR42X H1711102X;
label value TRICR53X H1711103X;
label value TRIDE14X H1711104X;
label value TRIEV14 H1711105X;
label value TRIEX14X H1711106X;
label value TRIEX31X H1711107X;
label value TRIEX42X H1711108X;
label value TRIFE14X H1711109X;
label value TRIJA14X H1711110X;
label value TRIJL14X H1711111X;
label value TRIJU14X H1711112X;
label value TRILI14X H1711113X;
label value TRILI31X H1711114X;
label value TRILI42X H1711115X;
label value TRIMA14X H1711116X;
label value TRIMY14X H1711117X;
label value TRINO14X H1711118X;
label value TRIOC14X H1711119X;
label value TRIPR14X H1711120X;
label value TRIPR31X H1711121X;
label value TRIPR42X H1711122X;
label value TRISE14X H1711123X;
label value TRIST14X H1711124X;
label value TRIST31X H1711125X;
label value TRIST42X H1711126X;
label value TRTIMP14 H1711127X;
label value TYPEPE42 H1711128X;
label value UNABLE31 H1711129X;
label value UNABLE53 H1711130X;
label value UNEIMP14 H1711131X;
label value UNHAP42 H1711132X;
label value UNINS14 H1711133X;
label value UNION31 H1711134X;
label value UNION31H H1711135X;
label value UNION42 H1711136X;
label value UNION42H H1711137X;
label value UNION53 H1711138X;
label value UNION53H H1711139X;
label value USCNOT42 H1711140X;
label value VETIMP14 H1711141X;
label value VISWCP14 H1711142X;
label value WAGIMP14 H1711143X;
label value WASAFDC H1711144X;
label value WASCHAMP H1711145X;
label value WASESTB H1711146X;
label value WASMCAID H1711147X;
label value WASMCARE H1711148X;
label value WASOTGOV H1711149X;
label value WASOTHER H1711150X;
label value WASPRIV H1711151X;
label value WASSSI H1711152X;
label value WASSTAT1 H1711153X;
label value WASSTAT2 H1711154X;
label value WASSTAT3 H1711155X;
label value WASSTAT4 H1711156X;
label value WASVA H1711157X;
label value WCPIMP14 H1711158X;
label value WHITPR42 H1711159X;
label value WHNBPR42 H1711160X;
label value WHNBST42 H1711161X;
label value WHNDEN42 H1711162X;
label value WHNEAT42 H1711163X;
label value WHNHEL42 H1711164X;
label value WHNHGT42 H1711165X;
label value WHNLAP42 H1711166X;
label value WHNPHY42 H1711167X;
label value WHNSAF42 H1711168X;
label value WHNSMK42 H1711169X;
label value WHNWGT42 H1711170X;
label value WILFIL14 H1711171X;
label value WLKDIF31 H1711172X;
label value WLKDIF53 H1711173X;
label value WLKLIM31 H1711174X;
label value WLKLIM53 H1711175X;
label value WRGLAS42 H1711176X;
label value WRKLIM31 H1711177X;
label value WRKLIM53 H1711178X;
label value YCHJ3142 H1711179X;
label value YCHJ4253 H1711180X;
label value YNOUSC42 H1711181X;
label value YRSINUS H1711182X;
label value ZIDVA14 H1711183X;
label value ZIFOSR14 H1711184X;
label value ZIFTRI14 H1711185X;
label value ZIFVA14 H1711186X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H171.LOG and a data file named H171.DTA.  If these files (H171.DTA and H171.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

